% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareGroupRIO.R
\name{compareGroupRIO}
\alias{compareGroupRIO}
\title{Compare individual elicited distributions with linear pool and RIO distribution}
\usage{
compareGroupRIO(
  groupFit,
  RIOFit,
  type = "density",
  dLP = "best",
  dRIO = "best",
  xlab = "x",
  ylab = expression(f[X](x)),
  fs = 12
)
}
\arguments{
\item{groupFit}{either an object of class \code{elicitation}, or the file path
for a .csv file exported from the elicitMultiple() app. This should contain 
the individually elicited judgements from the experts}

\item{RIOFit}{an object of class \code{elicitation} containing a single set of 
of probability judgements corresponding to the "Rational Impartial Observer (RIO)".}

\item{type}{the plot used to show the comparison: one of "quartiles", "tertiles" or "density".}

\item{dLP}{the distribution fitted to each expert's judgements and to the linear pool. Options are 
Options are "normal", "t", "gamma", "lognormal", "logt","beta", "mirrorgamma",
"mirrorlognormal", "mirrorlogt" "hist" (for a histogram fit), and "best" (for best fitting).}

\item{dRIO}{the distribution fitted to RIO's judgements. Options are the same as for \code{dLP}.}

\item{xlab}{x-axis label in plot}

\item{ylab}{y-axis label in plot}

\item{fs}{font size used in plot}
}
\description{
Produce one of three plots to compare the individual elicited judgements with the final
elicited distribution, chosen to represent the views of a "Rational Impartatial Observer" (RIO)
as part of the SHELF process. A linear pool of fitted distributions from the individually elicited
judgements is also obtained. The plot choices are a display of the quartiles, a display of the tertiles,
and a plot of the various density functions.
}
\examples{
\dontrun{
l <- c(2, 1, 5, 1)
u <- c(95, 90, 65, 40)
v <- matrix(c(15, 25, 40,
 10, 20, 40,
 10, 15, 25,
 5, 10, 20),
 3, 4)
p <- c(0.25, 0.5, 0.75)
group <- fitdist(vals = v, probs = p, lower = l, upper = u)
rio <- fitdist(vals = c(12, 20, 25), probs = p, lower = 1, upper = 100)
compareGroupRIO(groupFit = group, RIOFit = rio, dRIO = "gamma")
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
