# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit allen-otero.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(SEI)
library(ggplot2)
library(dplyr)
library(xts)
library(zoo)
library(gridExtra)


## -----------------------------------------------------------------------------
table_data <- matrix(c(
  "Normal", 1.28, 1.64, 1.96, -1.28, -1.64, -1.96,
  "Probability", 0.9, 0.95, 0.975, 0.1, 0.05, 0.025,
  "Bounded", 0.8, 0.9, 0.95, -0.8, -0.9, -0.95
), ncol = 7, byrow = TRUE)

knitr::kable(table_data, format = "simple", align = "c",
             col.names = c("Index Type", "Moderate", "Severe", "Extreme", "Moderate", "Severe", "Extreme"),
             caption = "Possible thresholds used to define droughts when using each of the three types of standardised indices. Values are shown for droughts defined when the threshold is exceeded (left), and fallen below (right).")


## -----------------------------------------------------------------------------
table_data <- matrix(c(
  "Empirical", '`"empirical"`', "range($x_{1}, \\dots, x_{n}$)",
  "Kernel density estimation", '`"kde"`', "($-\\infty$, $\\infty$)",
  "Normal", '`"norm"`', "($-\\infty$, $\\infty$)",
  "Log-normal", '`"lnorm"`', "[$0$, $\\infty$)",
  "Logistic", '`"logis"`', "($-\\infty$, $\\infty$)",
  "Log-logistic", '`"llogis"`', "[$0$, $\\infty$)",
  "Exponential", '`"exp"`', "[$0$, $\\infty$)",
  "Gamma", '`"gamma"`', "[$0$, $\\infty$)",
  "Weibull", '`"weibull"`', "[$0$, $\\infty$)"
), ncol = 3, byrow = TRUE)

knitr::kable(table_data, format = "simple", align = "c",
             col.names = c("Distribution", "Argument Code", "Support"),
             caption = "Distributions available in \\CRANpkg{SEI}, and their supports.")


## ----std_index_example, echo = TRUE-------------------------------------------
x <- rgamma(1000, shape = 2, scale = 1)
x_std <- std_index(x)


## ----echo = TRUE, fig.height = 9, fig.height = 3, fig.align = "center", out.width = "\\linewidth", fig.cap="Histogram of values sampled from a gamma distribution, and corresponding standardised values."----
plot_raw <- plot_sei(x, type = "hist", title = "Raw")
plot_std <- plot_sei(x_std, type = "hist", title = "Standardised")
grid.arrange(plot_raw, plot_std, nrow = 1)


## ----load_supply_data, echo=TRUE----------------------------------------------
data("data_supply", package = "SEI")
head(data_supply)


## ----subset_germany, echo=TRUE------------------------------------------------
de_supply_h <- subset(data_supply, country == "Germany")
de_supply_h <- xts::xts(de_supply_h$PWS, de_supply_h$date) # convert to xts


## ----rescale, echo=TRUE-------------------------------------------------------
de_supply_d <- xts::apply.daily(de_supply_h, "sum")    # daily data
de_supply_w <- xts::apply.weekly(de_supply_h, "sum")   # weekly data


## ----echo=TRUE, fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Time series of 2019 renewable energy production in Germany at hourly, daily, and weekly time scales."----
lab <- "Renewable Energy Production (GWh)"
plot_h <- plot_sei(de_supply_h, lab = lab, title = "Hourly")
plot_d <- plot_sei(de_supply_d, lab = lab, title = "Daily")
plot_w <- plot_sei(de_supply_w, lab = lab, title = "Weekly")
grid.arrange(plot_h, plot_d, plot_w, nrow = 1)


## ----calculate_index, echo=TRUE, warning=FALSE--------------------------------
srepi_h <- std_index(de_supply_h)
srepi_d <- std_index(de_supply_d)
srepi_w <- std_index(de_supply_w, dist = "kde")


## ----echo=TRUE, fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Time series of 2019 SREPI values in Germany at hourly, daily, and weekly time scales."----
lab <- "SREPI"
ylims <- c(-3, 3)
plot_h <- plot_sei(srepi_h, lab = lab, ylims = ylims, title = "Hourly")
plot_d <- plot_sei(srepi_d, lab = lab, ylims = ylims, title = "Daily")
plot_w <- plot_sei(srepi_w, lab = lab, ylims = ylims, title = "Weekly")
grid.arrange(plot_h, plot_d, plot_w, nrow = 1)


## ----use_rescale, echo=TRUE---------------------------------------------------
z <- std_index(de_supply_h, rescale = "days")
all.equal(srepi_d, z)


## ----fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Histogram of 2019 daily renewable energy production and SREPI values in Germany."----
plot_raw <- plot_sei(de_supply_d, type = "hist",
                     lab = "Renewable Energy Production (GWh)")
plot_ind <- plot_sei(srepi_d, type = "hist", lab = "SREPI")
grid.arrange(plot_raw, plot_ind, nrow = 1)


## ----fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Histogram of 2019 daily renewable energy production and SREPI values in Germany, where the indices are probability and bounded indices."----
srepi_d_prob <- std_index(de_supply_d, index_type = "probability")
plot_prob <- plot_sei(srepi_d_prob, type = "hist", lab = "SREPI",
                      ylims = c(0, 2), title = "Probability")
srepi_d_bnd <- std_index(de_supply_d, index_type = "bounded")
plot_bnd <- plot_sei(srepi_d_bnd, type = "hist", lab = "SREPI",
                     ylims = c(0, 1), title = "Bounded")
grid.arrange(plot_prob, plot_bnd, nrow = 1)


## ----define_droughts, echo=TRUE-----------------------------------------------
thresholds <- qnorm(c(0.1, 0.05, 0.025)) # -1.28, -1.64, -1.96
drought_df <- get_drought(srepi_d, thresholds, exceed = F)


## ----calculate event frequency, echo=TRUE-------------------------------------
num_ev <- table(drought_df$ins)
names(num_ev) <- c("None", "Moderate", "Severe", "Extreme")
print(num_ev)


## ----calculate event duration, echo=TRUE--------------------------------------
table(drought_df$dur[drought_df$dur > 0])


## ----calculate event magnitude, echo=TRUE-------------------------------------
mean(drought_df$mag[drought_df$mag != 0])


## ----load_wind_data, echo=TRUE------------------------------------------------
data("data_wind_de", package = "SEI")
data_wind_de <- subset(data_wind_de, format(date, "%Y") >= 2017)
head(data_wind_de)


## ----rescale_wind-------------------------------------------------------------
de_wind_d <- xts::xts(data_wind_de$wsmean, data_wind_de$date) # convert to xts
de_wind_w <- xts::apply.weekly(de_wind_d, FUN = "mean")       # weekly data
de_wind_m <- xts::apply.monthly(de_wind_d, FUN = "mean")      # monthly data


## ----echo=TRUE, fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Daily, weekly and monthly time series of average wind speed in Germany between 2017 and 2019."----
lab <- "Wind speed (m/s)"
ylims <- c(0, 8)
plot_ws_d <- plot_sei(de_wind_d, lab = lab, ylims = ylims, title = "Daily")
plot_ws_w <- plot_sei(de_wind_w, lab = lab, ylims = ylims, title = "Weekly")
plot_ws_m <- plot_sei(de_wind_m, lab = lab, ylims = ylims, title = "Monthly")
grid.arrange(plot_ws_d, plot_ws_w, plot_ws_m, nrow = 1)


## ----fit_ws_dists, echo=TRUE--------------------------------------------------
out_gamma <- fit_dist(data_wind_de$wsmean, dist = "gamma")
out_lnorm <- fit_dist(data_wind_de$wsmean, dist = "lnorm")
out_weibull <- fit_dist(data_wind_de$wsmean, dist = "weibull")


## ----aic, echo=TRUE-----------------------------------------------------------
aic_vec <- c(out_gamma$fit_props['aic'],
             out_lnorm$fit_props['aic'],
             out_weibull$fit_props['aic'])
names(aic_vec) <- c("Gamma", "Log-normal", "Weibull")
print(aic_vec)


## ----ksp, echo=TRUE-----------------------------------------------------------
ksp_vec <- c(out_gamma$fit_props['ks_pval'],
             out_lnorm$fit_props['ks_pval'],
             out_weibull$fit_props['ks_pval'])
names(ksp_vec) <- c("Gamma", "Log-normal", "Weibull")
print(round(ksp_vec, 4))


## ----ws_plot_dist_gam, echo=TRUE----------------------------------------------
x <- seq(0, 9, length.out = length(de_wind_d))
xlab <- "Wind speed (m/s)"
pars_gam <- out_gamma$params

plt_gam <- plot_sei(de_wind_d, type = "hist", lab = xlab, title = "Gamma") +
  geom_line(aes(x = x, y = dgamma(x, pars_gam[1], pars_gam[2])), col = "blue")


## ----echo=FALSE, fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Distribution of daily wind speeds in Germany between 2017 and 2019, along with estimated gamma, log-normal, and Weibull densities."----
# Log-normal distribution
plt_lnorm <- plot_sei(de_wind_d, type = "hist", lab = xlab, title = "Log-normal")
plt_lnorm <- plt_lnorm + geom_line(aes(x = x, y = dlnorm(x, out_lnorm$params[1], out_lnorm$params[2])), col = "blue")

# Weibull distribution
plt_weib <- plot_sei(de_wind_d, type = "hist", lab = xlab, title = "Weibull")
plt_weib <- plt_weib + geom_line(aes(x = x, y = dweibull(x, out_weibull$params[1], out_weibull$params[2])), col = "blue")

grid.arrange(plt_gam, plt_lnorm, plt_weib, nrow = 1)


## ----get_std_indices, echo=TRUE-----------------------------------------------
sei_ws_gam <- std_index(de_wind_d, dist = "gamma")
sei_ws_lnorm <- std_index(de_wind_d, dist = "lnorm")
sei_ws_weib <- std_index(de_wind_d, dist = "weibull")


## ----fig.width=9, fig.height=3, fig.align="center", out.width = "\\linewidth", fig.cap="Distribution of standardised wind speed indices (SWSI) constructed using the gamma, log-normal, and Weibull distributions. The standard normal density is displayed in blue."----
x <- seq(-3.5, 3.5, length.out = length(sei_ws_gam))
xlab <- "SWSI"
plt_gam <- plot_sei(sei_ws_gam, type = "hist", lab = xlab, title = "Gamma") +
  geom_line(aes(x = x, y = dnorm(x)), col = "blue")
plt_lnorm <- plot_sei(sei_ws_lnorm, type = "hist", lab = xlab, title = "Log-normal") +
  geom_line(aes(x = x, y = dnorm(x)), col = "blue")
plt_weib <- plot_sei(sei_ws_weib, type = "hist", lab = xlab, title = "Weibull") +
  geom_line(aes(x = x, y = dnorm(x)), col = "blue")
grid.arrange(plt_gam, plt_lnorm, plt_weib, nrow = 1)

