% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-Individuals.R
\docType{class}
\name{Individuals-class}
\alias{Individuals-class}
\title{Class Individuals}
\description{
\code{Individuals} Class consists of spatio-temporal parameters about exposed populations.

Individual gets coordinates (as SpatialPoints), a date of birth, a life duration, an intern toxic concentration over the time and a toxic threshold (max value of toxic before death).

 Each individual in an Individuals object is identified by an ID which is use as index to acces attributs in the object.
}
\details{
Objects can be created by calling of the allocator new("Individuals", ...), or (preferred) by calling one of the wrapped functions \link{simulateIndividuals} or \link{loadIndividuals}.
}
\section{Slots}{

\describe{
\item{\code{n}}{individuals Number}

\item{\code{coordinate}}{individuals coordinates (as SpatialPoints)}

\item{\code{xmin}}{Abscissa left value}

\item{\code{xmax}}{Abscissa right value}

\item{\code{ymin}}{Ordinate top value}

\item{\code{ymax}}{Ordinate bottom value}

\item{\code{dob}}{Date of birth (as vector)}

\item{\code{life_duration}}{individuals life duration (as vector)}

\item{\code{intern_toxic}}{individuals intern toxic concentration in time (as matrix)}

\item{\code{toxic_threshold}}{individuals max toxic concentration before death (as vector)}

\item{\code{mintime}}{First day}

\item{\code{maxtime}}{Last day}
}}
\seealso{
\code{\link{simulateIndividuals}} , \code{\link{loadIndividuals}}
}

