% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mdp}
\alias{mdp}
\title{Mean Difference for Pairs}
\usage{
mdp(x, g1, g2, f, s)
}
\arguments{
\item{x}{a column vector of scores on which the rsd is conditioned}

\item{g1}{a column vector of equated scores based on a single subpopulation (aligned with elements in x)}

\item{g2}{a column vector of equated scores based on a different single subpopulation (aligned with elements in x)}

\item{f}{a column vector of relative frequency associated with each raw score (can be based on either overall population or a subpopulation) (aligned with elements in x)}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized mean difference)}
}
\value{
mean difference
}
\description{
The mean difference index (\eqn{MD}{MD}) for pairs is the unconditional version of \eqn{D(x)}{D(x)}. It is the expectation across \eqn{x}{x} of the arithmetic differences between any \eqn{y_j(x)}{y_j(x)} and \eqn{y_{j'}(x)}{y_j'(x)} equated scores. Formally,
\deqn{MD=\frac{\sum_{x}P_x\lbrack y_j(x)-y_{j'}(x)\rbrack}{\sigma_x},}{MD=sum(P[y_j(x)-y_j'(x)|])/s,}
where \eqn{P_x}{P} is the proportion of examinees scoring at \eqn{x}{x} and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores in the (sub)population of interest. It is considered a pairwise, unconditional index. It was originally presented by Kolen and Brennan (2004). It provides practitioners with a summary of the magnitude and direction of mean differences between equated scores based on two subpopulations.
}
\note{
The equally weighted version of this index (Kolen & Brennan, 2004) can be obtained by inputting an \eqn{f}{f} vector consisting of identical elements that sum to 1. For example, using f=c(rep(.047619,21)) with the example data set, ex.data.
}
\examples{
#Unstandardized MD for subpopulations 1 and 2 in the example data set, ex.data
mdp(x=ex.data[,1],g1=ex.data[,3],g2=ex.data[,4],f= ex.data[,8])

#Unstandardized MD for subpopulations 4 and 5 in the example data set, ex.data
mdp(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],f= ex.data[,8])

#Standardized MD for subpopulations 4 and 5 in the example data set, ex.data
mdp(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],f= ex.data[,8],s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Kolen, M.J., & Brennan, R.L. (2004). Test equating, scaling, and linking: Methods and practices (2nd ed.). NY: Springer.}
}
}
\seealso{
\code{\link{dx}}
}

