% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bas.polygon.r
\name{bas.polygon}
\alias{bas.polygon}
\title{Draws a Balanced Acceptance Sample (BAS) from an area resource (polygons).}
\usage{
bas.polygon(x, n)
}
\arguments{
\item{x}{A \code{SpatialPolygons} or \code{SpatialPolygonsDataFrame} object. 
This object
must contain at least 1 polygon.  If it contains more than 1 polygon, the
BAS sample is drawn from the union of all.}

\item{n}{Sample size.  Number of locations to draw from the union of all
polygons contained in \code{x}.}
}
\value{
A \code{SDrawSample} object, which is a  
\code{SpatialPointsDataFrame} object containing points in the BAS sample, 
in BAS order.
 Attributes of the sample points are: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point.  This 
  encodes the BAS order.  \code{return[order(return$sampleID),]} will sort the 
  returned object in BAS order.
  
  \item \code{geometryID}: The ID of the polygon in \code{x} which each 
  sample point falls.  The 
  ID of polygons in \code{x} are \code{row.names(geometry(x))}. 
  \item Any attributes of the original polygons (in \code{x}). 
}

Additional attributes of the output object, beyond those which 
make it a \code{SpatialPointsDataFrame}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "polygon").
   \item \code{sample.type}: Type of sample drawn. (i.e., "BAS").
   \item \code{random.start}: The random seed of the random-start Halton sequence 
   that produced the sample.  This is a vector of length 2 whose elements are 
   random integers between 0 and \code{\link{maxU}}. 
   This routine ensures that the point
   associated with this index 
   falls inside a polygon of \code{x}.  i.e., 
   that \code{halton(1,2,random.start)} scaled by a square bounding box
   (see attribute \code{bas.bbox} below)
   lies inside a polygon of \code{x}.  
   
   Note that \code{halton(1,2,random.start+i)}, for 
   \code{i} > 0, is not guaranteed to fall inside a polygon of \code{x}
   when scaled by \code{bas.bbox}. The sample consists of the point 
   associated with \code{random.start} and the next \code{n-1}
   Halton points in sequence that fall inside a polygon
   of \code{x}. 
   
   
   \item \code{bas.bbox}: The square bounding box surrounding \code{x}
   used to scale Halton points.  A scaled Halton sequence of n points
   is \code{bas.bbox[,"min"] +} \code{t(halton(n,2,random.start)) *} 
   \code{rep( max(diff(t(bas.bbox))), 2)}.
   
}
}
\description{
Draws a BAS sample from a SpatialPolygons* object
}
\details{
A BAS sample is drawn from the union of all polygons in \code{x} by
enclosing all polygons in a bounding square and selecting a randomized
Halton sequence of points from the bounding square.  Points falling outside
all polygons are discarded until exactly \code{n} locations are selected
inside the polygons.

The sampling frame for routine is infinite and contains all (infinitesimally 
small) points in the union of polygons in \code{x}.
}
\examples{
#   Draw sample
WA_sample <- bas.polygon(WA, 100)  

#   Plot
plot( WA )

# Plot first 100 sample locations
points( WA_sample[ WA_sample$siteID <= 100, ], pch=16 ) 

# Plot second 100 locations 
points( WA_sample[ WA_sample$siteID >  100, ], pch=1 )  


}
\author{
Trent McDonald
}
\references{
Robertson, B.L., J. A. Brown, T. L. McDonald, and P. Jaksons
(2013) "BAS: Balanced Acceptance Sampling of Natural Resources", Biometrics,
v69, p. 776-784.
}
\seealso{
\code{\link{bas.line}}, \code{\link{bas.point}}, \code{\link{sdraw}}
}
\keyword{design}
\keyword{survey}

