% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corVar.R
\name{corVar}
\alias{corVar}
\title{Print Correlated Variables}
\usage{
corVar(
  bg,
  method = "spearman",
  cor_th = NULL,
  order = TRUE,
  remove_diagonal = TRUE
)
}
\arguments{
\item{bg}{\linkS4class{SWD} object with the locations used to compute the
correlation between environmental variables.}

\item{method}{character. The method used to compute the correlation matrix.}

\item{cor_th}{numeric. If provided it prints only the variables whose
correlation coefficient is higher or lower than the given threshold.}

\item{order}{logical. If \code{TRUE} the variable are ordered from the most to the
less highly correlated.}

\item{remove_diagonal}{logical. If \code{TRUE} the values in the diagonal are
removed.}
}
\value{
A data.frame with the variables and their correlation.
}
\description{
Utility that prints the name of correlated variables and the relative
correlation coefficient value.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd",
                    full.names = TRUE)

predictors <- terra::rast(files)

# Prepare background locations
bg_coords <- terra::spatSample(predictors,
                               size = 10000,
                               method = "random",
                               na.rm = TRUE,
                               xy = TRUE,
                               values = FALSE)

# Create SWD object
bg <- prepareSWD(species = "Virtual species",
                 a = bg_coords,
                 env = predictors,
                 categorical = "biome")

# Get the correlation among all the environmental variables
corVar(bg,
       method = "spearman")

# Get the environmental variables that have a correlation greater or equal to
# the given threshold
corVar(bg,
       method = "pearson",
       cor_th = 0.8)
}
\author{
Sergio Vignali
}
