% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSamplesToBg.R
\name{addSamplesToBg}
\alias{addSamplesToBg}
\title{Add Samples to Background}
\usage{
addSamplesToBg(x, all = FALSE)
}
\arguments{
\item{x}{\linkS4class{SWD} object.}

\item{all}{logical. If \code{TRUE} it adds all the presence locations even if
already included in the background locations. This is equivalent to the
Maxent argument \code{addallsamplestobackground=true}.}
}
\value{
An object of class \linkS4class{SWD}.
}
\description{
The function add the presence locations to the background. This is equivalent
to the Maxent argument \code{addsamplestobackground=true}.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd",
                    full.names = TRUE)

predictors <- terra::rast(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species",
                   p = p_coords,
                   a = bg_coords,
                   env = predictors,
                   categorical = "biome")
data

# Add presence locations with values not included in the backgrounds to the
# background locations
new_data <- addSamplesToBg(data)
new_data

# Add all the presence locations to the background locations, even if they
# have values already included in the backgrounds
new_data <- addSamplesToBg(data,
                           all = TRUE)
new_data
}
\author{
Sergio Vignali
}
