% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swd2csv.R
\name{swd2csv}
\alias{swd2csv}
\title{SWD to csv}
\usage{
swd2csv(swd, file_name)
}
\arguments{
\item{swd}{\linkS4class{SWD} object.}

\item{file_name}{character. The name of the file where to save the object.}
}
\description{
Save a \linkS4class{SWD} object as csv file.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")

# Save the SWD objct as csv file
swd2csv(train, "train_data.csv")
}
}
\author{
Sergio Vignali
}
