% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{varImp.SDTree}
\alias{varImp.SDTree}
\title{Extract variable importance of an SDTree}
\usage{
\method{varImp}{SDTree}(object)
}
\arguments{
\item{object}{an SDTree object}
}
\value{
A named vector of variable importance
}
\description{
This function extracts the variable importance of an SDTree. 
The variable importance is calculated as the sum of the decrease in the loss 
function resulting from all splits that use this covariate.
}
\examples{
data(iris)
tree <- SDTree(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width, iris, cp = 0.5)
varImp(tree)
}
\seealso{
\code{\link{varImp.SDForest}} \code{\link{SDTree}}
}
\author{
Markus Ulmer
}
