% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptote.R
\name{asymptote}
\alias{asymptote}
\title{Horizontal asymptotes of rational functions}
\usage{
asymptote(
  data = NULL,
  x = NULL,
  y = NULL,
  d1 = 1,
  d2 = 1,
  threshold = 0.95,
  proportional = TRUE
)
}
\arguments{
\item{data}{An output object from \code{\link{boot_overlap}} or \code{\link{boot_area}}.}

\item{x, y}{Numeric vectors of independent (x) and dependent (y) variables. 
These parameters will be ignored if \emph{data} is supplied.}

\item{d1, d2}{Maximal degrees of numerator (d1) and denominator (d2) of a rational function.}

\item{threshold}{Threshold value for considering an asymptote. 
Once the y value reaches the threshold, it is considered that an asymptote is reached.}

\item{proportional}{If TRUE (default), a threshold is calculated as \emph{estimated asymptote * threshold}. 
If FALSE, the value specified in \emph{threshold} is used in the analysis.}
}
\value{
A list containing a data frame (rational function fit associated with x values), an estimated horizontal asymptote, 
and the minimum sample size if an asymptote is reached.
}
\description{
Function to find horizontal asymptotes of a rational function.
}
\details{
This function fits a rational function to the input data. 
When an output object from \code{\link{boot_overlap}} or \code{\link{boot_area}} is supplied, 
a rational function is fit to the means of the bootstrap results (e.g. mean overlap probability) as a function of \emph{x} (e.g. sample size).
It then estimates horizontal asymptotes and identifies the sample size when an asymptote is considered.
}
\references{
Press, W. H., S. A. Teukolsky, W. T. Vetterling, and B. P. Flannery (2007). 
\emph{Numerical Recipes: The Art of Numerical Computing}. Third Edition, Cambridge University Press, New York.

Shimada et al., (in prep)
}
\seealso{
\code{\link{boot_overlap}}, \code{\link{boot_area}}
}
\author{
Takahiro Shimada
}
