% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory_inference.R
\name{infer_trajectory}
\alias{infer_trajectory}
\title{Infer linear trajectory through space}
\usage{
infer_trajectory(
  space,
  k = 4,
  thresh = 0.001,
  maxit = 10,
  stretch = 0,
  smoother = "smooth_spline",
  approx_points = 100
)
}
\arguments{
\item{space}{A numeric matrix or a data frame containing the coordinates of samples.}

\item{k}{The number of clusters to cluster the data into.}

\item{thresh}{convergence threshold on shortest distances to the curve.}

\item{maxit}{maximum number of iterations.}

\item{stretch}{A stretch factor for the endpoints of the curve,
allowing the curve to grow to avoid bunching at the end.
Must be a numeric value between 0 and 2.}

\item{smoother}{choice of smoother. The default is
\code{"smooth_spline"}, and other choices are \code{"lowess"} and
\code{"periodic_lowess"}. The latter allows one to fit closed curves.
Beware, you may want to use \code{iter = 0} with \code{lowess()}.}

\item{approx_points}{Approximate curve after smoothing to reduce computational time.
If \code{FALSE}, no approximation of the curve occurs. Otherwise,
\code{approx_points} must be equal to the number of points the curve
gets approximated to; preferably about 100.}
}
\value{
A list containing several objects:
\itemize{
\item \code{path}: the trajectory obtained by principal curves.
\item \code{time}: the time point of each sample along the inferred trajectory.
}
}
\description{
\code{infer_trajectory} infers a trajectory through samples in a given space in a four-step process:
\enumerate{
\item Perform \emph{k}-means clustering
\item Calculate distance matrix between cluster centers using a custom distance function
\item Find the shortest path connecting all cluster centers using the custom distance matrix
\item Iteratively fit a curve to the given data using principal curves
}
}
\examples{
## Generate an example dataset and visualise it
dataset <- generate_dataset(num_genes = 500, num_samples = 1000, num_groups = 4)
space <- reduce_dimensionality(dataset$expression, ndim = 2)
draw_trajectory_plot(space, progression_group = dataset$sample_info$group_name)

## Infer a trajectory through this space
traj <- infer_trajectory(space)

## Visualise the trajectory
draw_trajectory_plot(space, path=traj$path, progression_group = dataset$sample_info$group_name)
}
\seealso{
\code{\link{reduce_dimensionality}}, \code{\link{draw_trajectory_plot}}
}
