% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SANmcmc}
\alias{plot.SANmcmc}
\title{Plotting MCMC output}
\usage{
\method{plot}{SANmcmc}(
  x,
  type = c("boxplot", "ecdf", "scatter"),
  estimated_clusters = NULL,
  burnin = 0,
  palette_brewed = FALSE,
  ncores = 1,
  ...
)
}
\arguments{
\item{x}{object of class \code{SANmcmc} (the result of a call to \code{\link{sample_fiSAN}}, \code{\link{sample_fiSAN_sparsemix}}, 
\code{\link{sample_fSAN}}, \code{\link{sample_fSAN_sparsemix}}, or \code{\link{sample_CAM}}).}

\item{type}{what type of plot should be drawn (only for the left-side plot). Possible types are "boxplot", "ecdf", and "scatter".}

\item{estimated_clusters}{the output of a call to \code{\link{estimate_clusters}} (optional). It can be used to speed up the function if the partition has already been computed. 
If \code{estimated_clusters = NULL}, the displayed partition is computed using \code{\link{estimate_clusters}}.}

\item{burnin}{the length of the burn-in to be discarded (default is 2/3 of the iterations).}

\item{palette_brewed}{(logical) the color palette to be used. Default is \code{R} base colors (\code{palette_brewed = FALSE}).}

\item{ncores}{if the partition is computed, the number of CPU cores to use to estimate the clusters, i.e., the number of simultaneous runs at any given time. A value of zero indicates to use all cores on the system.}

\item{...}{additional graphical parameters to be passed when \code{type = "scatter"} is used.}
}
\value{
The function plots a summary of the fitted model.
}
\description{
Plot method for objects of class \code{SANmcmc}. 
The function displays two graphs, meant to analyze the estimated distributional and observational clusters.
}
\examples{
set.seed(123)
y <- c(rnorm(40,0,0.3), rnorm(20,5,0.3))
g <- c(rep(1,30), rep(2, 30))
out <- sample_fiSAN(nrep = 500, burn = 200, 
                    y = y, group = g, 
                    nclus_start = 2,
                    maxK = 20, maxL = 20,
                    beta = 1)
plot(out, type = "ecdf", palette_brewed = TRUE)

}
\seealso{
\code{\link{print.SANmcmc}}, \code{\link{estimate_clusters}}
}
