% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{HCR_fixedF}
\alias{HCR_fixedF}
\title{Simple fixed F harvest control rule}
\usage{
HCR_fixedF(Assessment, reps = 1, Ftarget = 0.1)
}
\arguments{
\item{Assessment}{An object of class \linkS4class{Assessment} with estimates of next year's abundance or biomass.}

\item{reps}{The number of replicates of the TAC recommendation (not used).}

\item{Ftarget}{The value of F.}
}
\value{
An object of class \linkS4class{Rec} with the TAC recommendation.
}
\description{
A simple control rule that explicitly specifies the target apical F independent of any model.
}
\details{
The catch advice is calculated using the catch equation of the corresponding
assessment. See \code{Assessment@forecast$catch_eq}, a function that returns the catch advice for a specified \code{Ftarget}.
}
\examples{
# create an MP to run in closed-loop MSE (fishes at F = 0.2)
F0.2 <- make_MP(SP, HCR_fixedF, Ftarget = 0.2)

\donttest{
myOM <- MSEtool::runMSE(MSEtool::testOM, MPs = c("FMSYref", "F0.2"))
}
}
\seealso{
\link{make_MP} \link{HCR_ramp}#'
}
\author{
Q. Huynh
}
