% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SAENET.R
\name{SAENET.predict}
\alias{SAENET.predict}
\title{Obtain the compressed representation of new data for specified layers from a stacked autoencoder.}
\usage{
SAENET.predict(h, new.data, layers = c(1), all.layers = FALSE)
}
\arguments{
\item{h}{The object returned from \code{SAENET.train()}}

\item{new.data}{A matrix of training data.}

\item{layers}{A numeric vector indicating which layers of the stacked autoencoder to return output for}

\item{all.layers}{A boolean value indicating whether to override \code{layers} and return the encoded output for all layers. Defaults to \code{FALSE}}
}
\value{
A list, for which each element corresponds to the output of \code{predict.autoencoder()} from package \code{autoencoder} for the specified layers of the stacked autoencoder.
}
\description{
Obtain the compressed representation of new data for specified layers from a stacked autoencoder.
}
\examples{
library(autoencoder)
data(iris)
#### Train a stacked sparse autoencoder with a (5,3) architecture and
#### a relatively minor sparsity penalty. Try experimenting with the
#### lambda and beta parameters if you haven't worked with sparse
#### autoencoders before - it's worth inspecting the final layer
#### to ensure that output activations haven't simply converged to the value of
#### rho that you gave (which is the desired activation level on average).
#### If the lambda/beta parameters are set high, this is likely to happen.


output <- SAENET.train(as.matrix(iris[1:100,1:4]), n.nodes = c(5,3),
                       lambda = 1e-5, beta = 1e-5, rho = 0.01, epsilon = 0.01)


predict.out <- SAENET.predict(output, as.matrix(iris[101:150,1:4]), layers = c(2))
}

