% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgIsolated.r
\name{vcgIsolated}
\alias{vcgIsolated}
\title{Remove isolated pieces from a surface mesh or split into connected components}
\usage{
vcgIsolated(mesh, facenum = NULL, diameter = NULL, split = FALSE,
  keep = 0, silent = FALSE)
}
\arguments{
\item{mesh}{triangular mesh of class "mesh3d".}

\item{facenum}{integer: all connected pieces with less components are
removed. If not specified or 0 and diameter is NULL, then only the component
with the most faces is kept.}

\item{diameter}{numeric: all connected pieces smaller diameter are removed
removed. \code{diameter = 0} removes all component but the largest ones. This option overrides the option \code{facenum}.}

\item{split}{logical: if TRUE, a list with all connected components (optionally matching requirements facenum/diameter) of the mesh will be returned.}

\item{keep}{integer: if split=T, \code{keep} specifies the number of largest chunks (number of faces) to keep.}

\item{silent}{logical, if TRUE no console output is issued.}
}
\value{
returns the reduced mesh.
}
\description{
Remove isolated pieces from a surface mesh, selected by a
minimum amount of faces or of a diameter below a given threshold.
Also the option only to keep the largest piece can be selected or to split a mesh into connected components.
}
\examples{
\dontrun{
data(humface)
cleanface <- vcgIsolated(humface)
}

}
\seealso{
\code{\link{vcgPlyRead}}
}
\author{
Stefan Schlager
}
\keyword{~kwd1}
\keyword{~kwd2}
