% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{Runuran.options}
\alias{Runuran.options}
\title{Set or return options for Runuran library}
\usage{
Runuran.options(...)
}
\arguments{
\item{\dots}{A list may be given as the only argument, or any number of
arguments may be in the \code{name=value} form, a character
string for the name of a parameter, or no argument at all
may be given.}
}
\value{
\code{Runuran.options} returns a list with the updated values of the
parameters. If the argument list is not empty, the returned list
is invisible. If a single character string is given, then the
value of the corresponding parameter is returned (or \code{NULL}
if the parameter is not used).
}
\description{
Library \pkg{Runuran} has some parameters which (usually) affect the
behavior of its functions. These can be set for the whole session
via \code{Runuran.options}.
}
\details{
The function provides a tool to control the behavior of library
\pkg{Runuran}. A list may be given as the only argument, or any
number of arguments may be in the \code{name=value} form.
If no arguments are specified then the function returns the
current settings of all parameters. 
If a single option name is given as character string, then its
value is returned (or \code{NULL} if it does not exist).
Option \emph{values} may be abbreviated.

Currently used parameters in alphabetical order:
\describe{
  \item{error.level}{
    verbosity level of error messages and warnings from the
    underlying UNU.RAN library. It has no effect on messages
    from the routines in this package.
    Warnings are useful for analysing possible problems with the
    selected combinations of distribution and method.
    However, they can produce quite a lot of output if the
    conditions of the method is appropriate for a distribution or
    the distribution has properties like very heavy tails or
    very high peaks.

    The following levels can be set:
    \describe{
      \item{\code{"default"}:}{
        same as \code{"warning"}.
      }
      \item{\code{"none"}:}{
        all error messages and warnings are suppressed.
      }
      \item{\code{"error"}:}{
        only show error messages.
      }
      \item{\code{"warning"}:}{
        show error messages and some of the warnings.
      }
      \item{\code{"all"}:}{
        show all error messages and warnings.
      }
    }
  }
}
}
\examples{

## save current options
oldval <- Runuran.options()

## show current options
Runuran.options("error.level")

## suppress all UNU.RAN error messages and warnings
Runuran.options(error.level="none")

## restore Runuran options
Runuran.options(oldval)

}
\author{
Josef Leydold \email{josef.leydold@wu.ac.at}
}
