% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indep_diff.R
\name{paired_indep_diff}
\alias{paired_indep_diff}
\title{Paired independent differences}
\usage{
paired_indep_diff(df, col1, col2)
}
\arguments{
\item{df}{(dataframe) Dataframe that contains the columns with b. and se. on their name to get the difference from}

\item{col1}{(numeric vector) Column name, not including "b.". Must have a column in dataframe also including "se.".}

\item{col2}{(numeric vector) Column name, not including "b.". Must have a column in dataframe also including "se.".}
}
\value{
Dataframe with extra columns containing the difference of the columns along with their standard error.
}
\description{
Get differences and standard errors from two columns starting with b. and se. assuming independence.
The second column will be subtracted from the first.
}
\examples{
paired_indep_diff(rrepest_pisa_age_gender,"mean.age..Male","mean.age..Female")

}
