% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpvt-package.R
\name{pvt_oil}
\alias{pvt_oil}
\title{Create a matrix of PVT properties for black oil samples}
\usage{
pvt_oil(
  input_unit = "SI",
  output_unit = "SI",
  fluid = "black_oil",
  pvt_model = "Standing",
  visc_model = "Beggs_Robinson",
  t = 85.4,
  p = 35000,
  oil_api = 38,
  gas_spgr = 0.67,
  nhc_composition = c(0, 0, 0),
  rsi = NULL,
  pb = 29500,
  warning = "yes"
)
}
\arguments{
\item{input_unit}{input unit system for parameters, a character string either 'SI' or 'Field'}

\item{output_unit}{output unit system for properties, a character string either 'SI' or 'Field'}

\item{fluid}{fluid type, the character string 'black_oil'}

\item{pvt_model}{PVT model, a character string. 'Standing', 'Vasquez_Beggs', 'Farshad_Petrosky', 'Al_Marhoun', and 'Glaso' models are currently available}

\item{visc_model}{viscosity model, a character string. 'Beggs_Robinson', and 'Al_Marhoun' models are currently available}

\item{t}{temperature, a numeric value either in 'C' or 'F' depending on the 'input_unit'}

\item{p}{pressure, a numeric value either in 'kPag' or 'Psig' depending on the 'input_unit'}

\item{oil_api}{API gravity of oil}

\item{gas_spgr}{gas specific gravity (Air = 1.0)}

\item{nhc_composition}{a vector of mole fractions for nitrogen, hydrogen sulfide, and carbon dioxide, respectively}

\item{rsi}{initial solution gas oil ratio in  'm3/m3' or 'SCF/STB' depending on the 'input_unit'. It is either NULL or a numeric value. If 'rsi' is NULL, then a numeric value must be assigned to 'pb'}

\item{pb}{bubble point pressure, a numeric value either in 'kPag' or 'Psig' depending on the 'input_unit'. it is either NULL or a numeric value. If 'pb' is NULL, then a numeric value must be assigned to 'rsi'}

\item{warning}{a charater string either 'yes' or 'no'}
}
\description{
The pvt_oil() generates a table of oil and gas PVT properties at reservoir temperature and pressures from the atmospheric condition up to the initial reservoir pressure. The estimated oil properties are solution gas-oil ratio, formation volume factor, density, compressibility, and viscosity. Estimated PVT properties for the associated gas are compressibility factor, formation volume factor, density, compressibility, viscosity, and pseudo-pressure.
}
\examples{
pvt_oil_results_1 <- pvt_oil(input_unit = "Field", output_unit = "Field", fluid = "black_oil",
pvt_model = "Standing", visc_model = "Beggs_Robinson",
t = 200, p = 3000, oil_api = 35, gas_spgr = 0.8,
nhc_composition = c(0.05,0.02,0.04), rsi = 650, pb = NULL, warning = "no")

head(pvt_oil_results_1)

pvt_oil_results_2 <- pvt_oil(input_unit = "SI", output_unit = "Field", fluid = "black_oil",
pvt_model = "Vasquez_Beggs", visc_model = "Al_Marhoun",
t = 80, p = 20000, oil_api = 34.4, gas_spgr = 0.65,
nhc_composition = c(0.0,0.0,0.0), rsi = NULL, pb = 11350, warning = "yes")

head(pvt_oil_results_2)

}
\references{
\insertRef{Standing1947}{Rpvt}

\insertRef{Vasquez1980}{Rpvt}

\insertRef{Glaso1980}{Rpvt}

\insertRef{PetroskyJr.1998}{Rpvt}

\insertRef{Al-Marhoun1988}{Rpvt}

\insertRef{Beggs1975}{Rpvt}

\insertRef{Al-Marhoun2004}{Rpvt}

\insertRef{Spivey2007}{Rpvt}

\insertRef{Sutton2007}{Rpvt}
}
