% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_reg}
\alias{update_reg}
\title{Update coefficient vector of multiple linear regression}
\usage{
update_reg(mu0, Tau0, XSigX, XSigU)
}
\arguments{
\item{mu0}{The mean vector of the normal prior distribution for the coefficient vector.}

\item{Tau0}{The precision matrix (i.e. inverted covariance matrix) of the normal prior distribution for the coefficient vector.}

\item{XSigX}{The matrix \eqn{\sum_{n=1}^N X_n'\Sigma^{-1}X_n}. See below for details.}

\item{XSigU}{The vector \eqn{\sum_{n=1}^N X_n'\Sigma^{-1}U_n}. See below for details.}
}
\value{
A vector, a draw from the normal posterior distribution of the coefficient
vector in a multiple linear regression.
}
\description{
This function updates the coefficient vector of a multiple linear regression.
}
\details{
This function draws from the posterior distribution of \eqn{\beta} in the linear utility
equation \deqn{U_n = X_n\beta + \epsilon_n,} where \eqn{U_n} is the
(latent, but here assumed to be known) utility vector of decider \eqn{n = 1,\dots,N}, \eqn{X_n}
is the design matrix build from the choice characteristics faced by \eqn{n},
\eqn{\beta} is the unknown coefficient vector (this can be either the fixed
coefficient vector \eqn{\alpha} or the decider-specific coefficient vector \eqn{\beta_n}),
and \eqn{\epsilon_n} is the error term assumed to be normally distributed with mean \eqn{0}
and (known) covariance matrix \eqn{\Sigma}.
A priori we assume the (conjugate) normal prior distribution \deqn{\beta \sim N(\mu_0,T_0)}
with mean vector \eqn{\mu_0} and precision matrix (i.e. inverted covariance matrix) \eqn{T_0}.
The posterior distribution for \eqn{\beta} is normal with
covariance matrix \deqn{\Sigma_1 = (T_0 + \sum_{n=1}^N X_n'\Sigma^{-1}X_n)^{-1}} and mean vector
\deqn{\mu_1 = \Sigma_1(T_0\mu_0 + \sum_{n=1}^N X_n'\Sigma^{-1}U_n)}.
Note the analogy of \eqn{\mu_1} to the generalized least squares estimator
\deqn{\hat{\beta}_{GLS} = (\sum_{n=1}^N X_n'\Sigma^{-1}X_n)^{-1} \sum_{n=1}^N X_n'\Sigma^{-1}U_n} which
becomes weighted by the prior parameters \eqn{\mu_0} and \eqn{T_0}.
}
\examples{
### true coefficient vector
beta_true <- matrix(c(-1,1), ncol=1)
### error term covariance matrix
Sigma <- matrix(c(1,0.5,0.2,0.5,1,0.2,0.2,0.2,2), ncol=3)
### draw data
N <- 100
X <- replicate(N, matrix(rnorm(6), ncol=2), simplify = FALSE)
eps <- replicate(N, rmvnorm(mu = c(0,0,0), Sigma = Sigma), simplify = FALSE)
U <- mapply(function(X, eps) X \%*\% beta_true + eps, X, eps, SIMPLIFY = FALSE)
### prior parameters for coefficient vector
mu0 <- c(0,0)
Tau0 <- diag(2)
### draw from posterior of coefficient vector
XSigX <- Reduce(`+`, lapply(X, function(X) t(X) \%*\% solve(Sigma) \%*\% X))
XSigU <- Reduce(`+`, mapply(function(X, U) t(X) \%*\% solve(Sigma) \%*\% U, X, U, SIMPLIFY = FALSE))
beta_draws <- replicate(100, update_reg(mu0, Tau0, XSigX, XSigU), simplify = TRUE)
rowMeans(beta_draws)
}
\keyword{internal}
\keyword{posterior}
