% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-lib.R
\docType{class}
\name{PolyhedronDatabase.class}
\alias{PolyhedronDatabase.class}
\title{PolyhedronDatabase}
\format{\code{\link{R6Class}} object.}
\usage{
PolyhedronDatabase.class
}
\description{
Scrapes all polyhedra in data folder to save a representation which is accesible by the final users upon call to \code{getPolyhedron()}.
}
\section{Fields}{

\describe{
\item{\code{polyhedra.rds.file}}{path of rds database file}

\item{\code{sources.config}}{Sources configuration for scraping different sources}

\item{\code{ledger}}{rr ledger of scraping process}

\item{\code{data}}{Polyhedra data from different sources}
}}

\section{Methods}{

\describe{
  \item{\code{initialize()}}{Initializes the object}
  \item{\code{existsSource(source)}}{Determines if the source exists on the database}
  \item{\code{getSource(source, strict=False)}}{Retrieves a source by name}
  \item{\code{addSource(source)}}{Adds a new source to the database}
  \item{\code{configPolyhedraRDSPath()}}{config path for rds database file}
  \item{\code{existsPolyhedron(source,polyhedron.name)}}{Determines if the polyhedron exists on the database}
  \item{\code{getPolyhedron(source, polyhedron.name, strict)}}{Retrieves a polyhedron by source and name}
  \item{\code{addPolyhedron(source,polyhedron,overwrite)}}{Adds a polyhedron by source and name, if orverwrite is TRUE,
          it will update any existing one by that source and name}
  \item{\code{configPolyhedraSource(source.config, max.quant)}}{Scrapes all polyhedra in the given
          directory for adding to db or testing}
  \item{\code{schedulePolyhedraSources(sources.config,max.quant, test)}}{Scrapes files applying parameter sources.config}
  \item{\code{getAvailablePolyhedra(sources,search.string)}}{Retrieves all polyhedron within the source those names
          match with search.string}
}
}

\keyword{datasets}
