


     POLY(5)						       POLY(5)



     NAME
	  poly - polyhedron database

     DESCRIPTION
	  The directory	/usr/lib/polyhedra contains an index file and
	  many polyhedron description files.  The index	file consists
	  of lines composed of the polyhedron number followed by a
	  horizontal tab and the polyhedron's name.  The polyhedron's
	  number is also the name of its description file.  The
	  routines of _p_o_l_y(3) read such	description files.

	  The description file consists	of a number of fields.	A
	  field	header is a line with an initial `:'.  The remainder
	  of the line is the field name.  Fields start with a field
	  header line and are terminated by the	next field header line
	  or by	end of file.  A	polyhedron's description is terminated
	  by the field `EOF'.  The fields include, but are not limited
	  to,

	  number      the polyhedron's number (written and read	with
		      the %d printf/scanf format).

	  name	      the polyhedron's name is less than 128
		      characters long and is not capitalized.

	  symbol      the _e_q_n(1) input for two symbols separated by a
		      tab; the Johnson symbol, and the Schlafli
		      symbol.

	  dual	      the name of the dual polyhedron optionally
		      followed by a horizontal tab and the number of
		      the dual.

	  vertices    the first	line contains the number of vertices.
		      The vertices are arranged	one per	line as	an
		      (_x,_y,_z) coordinate of white-space	separated
		      values (described	below).	 The vertices are
		      implicitly numbered starting at zero.

	  net	      the first	line contains the number of faces and
		      the maximum number of vertices in	a face.	 The
		      remaining	lines are the faces in the planar net.
		      Each face	has a vertex count followed by the
		      vertex numbers.  The vertices are	listed in
		      counter-clockwise	order as viewed	from outside
		      the polyhedron.

	  hinges      the first	line contains the number of hinges in
		      the planar net.  The remaining lines are hinge
		      connections.  The	format is _f_a_c_e_1	_s_i_d_e_1 _f_a_c_e_2
		      _s_i_d_e_2 _v_a_l_u_e.  Sides are numbered from zero.  If
		      the dihedral (_v_a_l_u_e) is greater than J, it is a



     Page 1		       Ninth Edition	     (printed 1/12/87)






     POLY(5)						       POLY(5)



		      reflex or	re-entrant hinge.

	  solid	      the first	line contains the number of faces and
		      the maximum number of vertices in	a face.	 The
		      remaining	lines are the faces in the 3D
		      polyhedron.  Each	face has a vertex count
		      followed by the vertex numbers.  The vertices
		      are listed in counter-clockwise order as viewed
		      from outside the polyhedron.

	  dihedral    the first	line contains the number of distinct
		      dihedrals.  Each dihedral	starts on a new	line
		      and has a	count and a value.  If the count is
		      non-zero,	then that many _f_a_c_e _e_d_g_e pairs (one
		      per line)	follow the dihedral value.

	  EOF	      the end of the polyhedron's description.

	  A value consists of a	floating point number optionally
	  followed by a	expression enclosed by `[]'.  The expression
	  is the exact value represented in _b_c(1) code with the
	  following function meanings: a(x) = tan-1(x),	b(x) = (x)1/3,
	  c(x) = cos(x), d(x) =	tan(x),	p = J, q(x) = x2,
	  r(x) = cos-1(x), s(x)	= sin(x), t = U.  The code may include
	  assignments but does not include white space.

     FILES
	  /usr/lib/polyhedra/index	  index	file
	  /usr/lib/polyhedra/[0-9]*	  description files

     SEE ALSO
	  poly(3), poly(7)























     Page 2		       Ninth Edition	     (printed 1/12/87)



