% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permissionsets.update.R
\name{permissionsets.update}
\alias{permissionsets.update}
\title{Update permission set details}
\usage{
permissionsets.update(id, contents, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the permission set}

\item{contents}{Permissions that this set contains as JSON or ordinary comma separated string. Possible permission names are: can_change_visibility_of_items, can_see_company_wide_statistics, can_delete_deals, can_see_deals_list_summary, can_export_data_from_lists, can_see_other_users_statistics this field must be a JSON.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update permission set details on pipedrive.
}
\examples{
\donttest{
permissionsets.update(id='e.g.',contents='e.g.',api_token='token',company_domain='exp')
}
}
