% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deals.update.R
\name{deals.update}
\alias{deals.update}
\title{Update a deal}
\usage{
deals.update(id, title = NULL, value = NULL, currency = NULL,
  user_id = NULL, person_id = NULL, org_id = NULL, stage_id = NULL,
  status = NULL, probability = NULL, lost_reason = NULL,
  visible_to = NULL, customList = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the deal}

\item{title}{Deal title}

\item{value}{Value of the deal}

\item{currency}{Currency of the deal. Accepts a 3-character currency code}

\item{user_id}{ID of the user who will be marked as the owner of this deal}

\item{person_id}{ID of the person this deal will be associated with}

\item{org_id}{ID of the organization this deal will be associated with}

\item{stage_id}{ID of the stage this deal will be placed in a pipeline (note that you can't supply the ID of the pipeline as this will be assigned automatically based on stage_id)}

\item{status}{open = Open, won = Won, lost = Lost, deleted = Deleted}

\item{probability}{Deal success probability percentage. Used/shown only when deal_probability for the pipeline of the deal is enabled.}

\item{lost_reason}{Optional message about why the deal was lost (to be used when status=lost)}

\item{visible_to}{Visibility of the deal. If omitted, visibility will not be changed.1 = Owner & followers (private); 3 = Entire company (shared) This field has the following domains: (1; 3)}

\item{customList}{List with custom fields. Example: list(`custom_field` = abc)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update a deal on pipedrive.
}
\examples{
\donttest{
deals.update(id='e.g.',api_token='token',company_domain='exp')
}
}
