\name{split.pdb}
\alias{split.pdb}
\alias{unsplit.pdb}
\title{Divide and Reassemble \sQuote{pdb} Objects}
\description{
\code{split} divides a \sQuote{pdb} object by groups of atoms defined by \code{f}. \code{unsplit} reverses the effect of \code{split}.
}
\usage{
\method{split}{pdb}(x, f, drop = FALSE, ...)

\method{unsplit}{pdb}(value, f, drop = FALSE, ...)
}
\arguments{
  \item{x}{an object of class \sQuote{pdb} to be divided into groups.}
  \item{f}{a \sQuote{factor} in the sense that \code{\link{as.factor}(f)}
    defines the grouping, or a list of such factors in which case their
    interaction is used for the grouping.}
  \item{drop}{logical indicating if levels that do not occur should be dropped
    (if \code{f} is a \code{factor} or a list).}
  \item{value}{a list of 'pdb' objects compatible with a
    splitting of \code{x}. Recycling applies if the lengths do not match.}
  \item{\dots}{further potential arguments passed to methods.}
}
\details{
\code{split} produce a list of \sQuote{pdb} objects with the same \code{cryst1}, \code{title} and \code{remark} components as \code{x}. Only its \code{atoms} component is splitted while its \code{conect} component is cleaned to keep only the meaningful connectivity for each \sQuote{pdb} object of the list returned by the function. \code{unlist} produce a \sQuote{pdb} object with the same \code{cryst1}, \code{title} and \code{remark} components as the first element of \code{value}. The \code{atoms} and \code{conect} components of all the elements of \code{value} are combined by row.
}
\value{
The value returned from \code{split} is a list of \sQuote{pdb} objects containing the data for the groups of atoms. The components of the list are named by the levels of \code{f} (after converting to a factor, or if already a factor and \code{drop=TRUE}, dropping unused levels).

\code{unsplit} returns a \sQuote{pdb} object for which \code{split(x, f)} equals \code{value}.
}

\seealso{
\code{\link{split}}, \code{\link{unsplit}}, \code{\link{pdb}}
}
\examples{
\dontrun{

## Split a pdb file by residue IDs and write them into separated files
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb",package="Rpdb"))
file.names <- paste0(x$atoms$resname,"_",x$atoms$resid,".pdb")
file.names <- unique(file.names)
pdb.resid <- split(x, x$atoms$resid)
useless <- mapply(write.pdb, pdb.resid, file.names)

}
}
\keyword{ category }
