% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/IOFunctions.R
\name{[.RuleSetRST}
\alias{Extract.RuleSetRST}
\alias{[.RuleSetRST}
\title{The \code{[.} method for \code{"RuleSetRST"} objects}
\usage{
\method{[}{RuleSetRST}(x, i, ...)
}
\arguments{
\item{x}{a \code{"RuleSetRST"} object from which to extract rules(s) or in which to replace rules(s).
See \code{\link{RI.LEM2Rules.RST}}.}

\item{i}{integer indices specifying elements to be extracted or replaced.}

\item{...}{the other parameters.}
}
\value{
A subset of rules.
}
\description{
Subsetting a set of decision rules.
}
\examples{
###########################################################
## Example : Subsetting a set of decision rules
###########################################################
data(RoughSetData)
hiring.data <- RoughSetData$hiring.dt

rules <- RI.LEM2Rules.RST(hiring.data)

rules

# taking a subset of rules
rules[1:3]
rules[c(TRUE,FALSE,TRUE,FALSE)]

# replacing a subset of rules
rules2 <- rules
rules2[c(2,4)] <- rules[c(1,3)]
rules2
}
\author{
Andrzej Janusz
}

