% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RuleInduction.R
\name{RI.indiscernibilityBasedRules.RST}
\alias{RI.indiscernibilityBasedRules.RST}
\title{Rule induction from indiscernibility classes.}
\usage{
RI.indiscernibilityBasedRules.RST(decision.table, feature.set)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system.
See \code{\link{SF.asDecisionTable}}.}

\item{feature.set}{an object inheriting from the \code{"FeatureSubset"} class which is a typical output of feature
       selection methods based on RST  e.g. \code{\link{FS.greedy.heuristic.reduct.RST}}.
       See also \code{\link{FS.reduct.computation}}, \code{\link{FS.feature.subset.computation}} and
       \code{\link{FS.all.reducts.computation}} based on RST.}
}
\value{
An object of a class \code{"RuleSetRST"}, which is a list with additional attributes:
\itemize{
 \item \code{uniqueCls}: a vector of possible decision classes,
 \item \code{supportDenominator}: an integer giving the number of objects in the data,
 \item \code{clsProbs}: a vector giving the a priori probability of the decision classes,
 \item \code{majorityCls}: a class label representing the majority class in the data,
 \item \code{method}: the type a rule induction method used for computations,
 \item \code{dec.attr}: a name of the decision attribute in the data,
 \item \code{colnames}: a vector of conditional attribute names.
}
Each rule is a list with the following elements:
\itemize{
  \item \code{idx}: a vector of indexes of attribute that are used in antecedent of a rule,
  \item \code{values}: a vector of values of attributes indicated by \code{idx},
  \item \code{consequent}: a value of the consequent of a rule,
  \item \code{support}: a vactor of integers indicating objects from the data, which support a given rule,
  \item \code{laplace}: ia numeric value representing the Laplace estimate of the rule's confidence.
}
}
\description{
Rule induction from indiscernibility classes.
}
\details{
This function generates "if-then" decision rules from indiscernibility classes defined by a given
subset of conditional attributes.

After obtaining the rules, decision classes of new objects can be predicted using the \code{predict} method or
by a direct call to \code{\link{predict.RuleSetRST}}.
}
\examples{
###########################################################
## Example
##############################################################
data(RoughSetData)
hiring.data <- RoughSetData$hiring.dt

## determine feature subset/reduct
reduct <- FS.reduct.computation(hiring.data,
                                method = "permutation.heuristic",
                                permutation = FALSE)

rules <- RI.indiscernibilityBasedRules.RST(hiring.data, reduct)
rules
}
\author{
Andrzej Janusz
}
\seealso{
\code{\link{predict.RuleSetRST}}, \code{\link{RI.CN2Rules.RST}}, \code{\link{RI.LEM2Rules.RST}},
         \code{\link{RI.AQRules.RST}}.
}

