\name{MV.deletionCases}
\alias{MV.deletionCases}
\title{Missing value completion by deleting instances}
\usage{
MV.deletionCases(decision.table)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing a decision table. See
  \code{\link{SF.asDecisionTable}}.  Note: missing values
  are recognized as NA.}
}
\value{
A class \code{"MissingValue"}. See
\code{\link{MV.missingValueCompletion}}.
}
\description{
It is used for handling missing values by deleting
instances. It should be noted that the output of the
function is \code{val.NA} which contains indices of missing
values and their values (i.e., NA). Therefore, in order to
generate a new decision table (dataset) the user need to
execute \code{\link{SF.applyDecTable}}.
}
\examples{
#############################################
## Example : Deletion Cases
#############################################
dt.ex1 <- data.frame(
     c("high", "very_high", NA, "high", "high", "normal", "normal", NA),
     c(NA, "yes", "no", "yes", NA, "yes", "no", "yes"),
     c("no", "yes", "no", "yes", "yes", "no", "yes", NA),
     c("yes", "yes", "no", "yes", "no", "no", "no", "yes"))
colnames(dt.ex1) <- c("Temp", "Headache", "Nausea", "Flu")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4,
                                    indx.nominal = c(1:4))
indx = MV.deletionCases(decision.table)
}
\references{
J. Grzymala-Busse and W. Grzymala-Busse, "Handling Missing
Attribute Values," in Data Mining and Knowledge Discovery
Handbook, O. Maimon and L. Rokach, Eds. New York :
Springer, 2010, pp. 33-51
}
\seealso{
\code{\link{MV.missingValueCompletion}}
}

