% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{TipInstability}
\alias{TipInstability}
\alias{ColByStability}
\title{Tip instability}
\usage{
TipInstability(
  trees,
  log = TRUE,
  average = "mean",
  deviation = "sd",
  checkTips = TRUE
)

ColByStability(trees, log = TRUE, average = "mean", deviation = "sd")
}
\arguments{
\item{trees}{List of trees to analyse.}

\item{log}{Logical specifying whether to log-transform distances when
calculating leaf stability.}

\item{average}{Character specifying whether to use \code{'mean'} or \code{'median'}
tip distances to calculate leaf stability.}

\item{deviation}{Character specifying whether to use \code{'sd'} or \code{'mad'} to
calculate leaf stability.}

\item{checkTips}{Logical specifying whether to check that tips are numbered
consistently.}
}
\description{
\code{TipInstability()} calculates the instability of each leaf in a tree.
Unstable leaves are likely to display roguish behaviour.
}
\details{
\insertCite{SmithCons;textual}{Rogue} defines the \emph{instability} of a pair
of leaves as the median absolute divergence in the graph geodesic
(the number of edges in the shortest path between the leaves) across all
trees, normalized against the mean graph geodesic.
The instability of a single leaf is the mean instability of all pairs that
include that leaf; higher values characterise leaves whose position is more
variable between trees.

Other concepts of leaf instability include
\itemize{
\item The 'taxonomic instability index', as implemented in Mesquite:
described by \insertCite{Thomson2010;textual}{Rogue} as
\eqn{\sum\limits_{(x, y), j \neq i}{\frac{|D~ijx~ - D~ijy~|}{(D~ijx~ - D~ijy~)^2}}}{\sum[x, y, j != i] (D[ijx] - D[ijy] / (D[ijx] - D[ijy])^2 )},
where \eqn{D~ijx~}{D[ijx]} is the patristic distance (i.e. length of edges)
between leaves \eqn{i} and \eqn{j} in tree \eqn{x}.
\item the average stability of triplets (i.e. quartets including the root) that
include the leaf \insertCite{Thorley1999}{Rogue}, implemented in "Phyutility"
\insertCite{Smith2008}{Rogue}; and related to 'positional congruence'
measures \insertCite{Estabrook1992,Pol2009}{Rogue}.
}
}
\examples{
library("TreeTools", quietly = TRUE)
trees <- AddTipEverywhere(BalancedTree(8), 'Rogue')[3:6]
plot(consensus(trees), tip.col = ColByStability(trees))
instab <- TipInstability(trees, log = FALSE, ave = 'mean', dev = 'mad')
plot(ConsensusWithout(trees, names(instab[instab > 0.2])))
}
\references{
\insertAllCited{}
}
\seealso{
Other tip instability functions: 
\code{\link{TipVolatility}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tip instability functions}
