% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_orders_crypto.R
\name{api_orders_crypto}
\alias{api_orders_crypto}
\title{RobinHood API: Orders Crypto}
\usage{
api_orders_crypto(RH, action, order_id = NULL, cancel_url = NULL,
  currency_pair_id = NULL, type = NULL, time_in_force = NULL,
  price = NULL, quantity = NULL, side = NULL)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{action}{(string) one of "order", "status", "cancel", or "history"}

\item{order_id}{(string) action is "status" or "cancel", only order_id is required}

\item{cancel_url}{(string) url for posting a cancel order}

\item{currency_pair_id}{(string) currency pair id}

\item{type}{(string) "market" or "limit"}

\item{time_in_force}{(string) Good For Day ("gfd"), Good Till Canceled ("gtc"), Immediate or Cancel ("ioc"), or Opening ("opg")}

\item{price}{(number) the price you are willing to sell or buy at}

\item{quantity}{(int) number of shares you wish to transact}

\item{side}{(string) "buy" or "sell"}
}
\description{
Backend function called by place_order(), get_order_status(), cancel_order(). Issues a buy/sell order or
returns the status of an order. When issuing a buy order use the url column in the return data to check the
status or cancel the order.
}
