# Robust Mixture Regression



<!-- badges: start -->

[![License](http://img.shields.io/badge/license-GPL%20v3-orange.svg?style=flat)](http://www.gnu.org/licenses/gpl-3.0.en.html)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-ago/RobMixReg)](https://CRAN.R-project.org/package=RobMixReg)
[![cran checks](https://cranchecks.info/badges/worst/RobMixReg)](https://CRAN.R-project.org/web/checks/check_results_RobMixReg.html)
[![Total Downloads](https://cranlogs.r-pkg.org/badges/grand-total/RobMixReg)](https://cran.r-project.org/package=RobMixReg)
[![documentation](https://github.com/laresbernardo/lares/workflows/documentation/badge.svg)](https://CRAN.R-project.org/package=RobMixReg/RobMixReg.pdf)
[![travis](https://travis-ci.com/laresbernardo/lares.svg?branch=master)](https://travis-ci.org/github/changwn/RobMixReg)
[![Hi](https://img.shields.io/badge/say-hi-blue.svg)](https://changwn.github.io/)

<!-- badges: end -->
<!--   ![Download](https://cranlogs.r-pkg.org/badges/RobMixReg)   -->

[r package link](https://CRAN.R-project.org/package=RobMixReg) [https://CRAN.R-project.org/package=RobMixReg]

[manual document](https://CRAN.R-project.org/package=RobMixReg/RobMixReg.pdf) [https://CRAN.R-project.org/package=RobMixReg/RobMixReg.pdf]

[Paper download here:](https://arxiv.org/abs/2005.11599) [<Wennan Chang et al. , A New Algorithm using Component-wise Adaptive Trimming For Robust Mixture Regression, arxiv, 2020>](https://arxiv.org/abs/2005.11599)

[Wennan Chang](https://changwn.github.io/), [Chi Zhang\* ](https://zcslab.github.io/), [Sha Cao\* ](https://medicine.iu.edu/faculty/38873/cao-sha)

[Biomedical Data Research Lab (BDR)](https://zcslab.github.io/) 

[For other software, please refer to the BDR github page](https://github.com/zcslab)




# News

The package version control is in [News.md](https://changwn.github.io/RobMixReg/news/index.html)

# Install from CRAN
```
install.packages("RobMixReg)
library("RobMixReg")
```

# Install from github for most updated package. 
#### Please report the bug as the description in the Question&Problem.
```
library("devtools")
devtools::install_github("changwn/RobMixReg")
```

# Tutorial

A comprehensive and complete tutorial is [here](https://changwn.github.io/RobMixReg/articles/tutorial.html).

## Citations
If you find the code helpful in your resarch or work, please cite us.
```BibTex
@article{wennan2020cat,
  title={A New Algorithm using Component-wise Adaptive Trimming For Robust Mixture Regression},
  author={Chang, Wennan and Wan, Changlin and Zhou, Xinyu and Zhang, Chi and Cao, Sha},
  journal={arXiv preprint arXiv:2005.11599},
  year={2020}
}
```

# Questions & Problems

If you have any questions or problems, please feel free to open a new issue [here](https://github.com/changwn/RMR/issues). We will fix the new issue ASAP.  You can also email the maintainers and authors below.

- [Wennan Chang](https://changwn.github.io/)
(wnchang@iu.edu)

PhD candidate at BDR group, Indiana University School of Medicine

- [Sha Cao](https://medicine.iu.edu/faculty/38873/cao-sha/)
(shacao@iu.edu)

Assistant Professor

Department of Biostatistics, Indiana University School of Medicine

# Contributing

I’m happy to receive bug reports, suggestions, questions, and (most of
all) contributions to fix problems and add features. I prefer you use
the Github issues system over trying to reach out to me in other ways.
Pull requests for contributions are encouraged.
