#' @title 27 experimental studies from
#' \insertCite{anderson2010violent;textual}{RoBMA} that meet the best practice criteria
#'
#' @description The data set contains correlation coefficients, sample
#' sizes, and labels for 27 experimental studies focusing on the effect of
#' violent video games on aggressive behavior. The full original data can
#' found at https://github.com/Joe-Hilgard/Anderson-meta.
#'
#'
#' @format A data.frame with 3 columns and 23 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Anderson2010"


#' @title 9 experimental studies from
#' \insertCite{bem2011feeling;textual}{RoBMA} as described in
#' \insertCite{bem2011must;textual}{RoBMA}
#'
#' @description The data set contains Cohen's d effect sizes, standard errors,
#' and labels for 9 experimental studies of precognition from the infamous
#' \insertCite{bem2011feeling;textual}{RoBMA} as analyzed in his later meta-analysis
#' \insertCite{bem2011must}{RoBMA}.
#'
#' @format A data.frame with 3 columns and 9 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Bem2011"


#' @title 5 studies with a tactile outcome assessment from
#' \insertCite{poulsen2006potassium;textual}{RoBMA} of the effect of potassium-containing toothpaste
#' on dentine hypersensitivity
#'
#' @description The data set contains Cohen's d effect sizes, standard errors,
#' and labels for 5 studies assessing the tactile outcome from a meta-analysis of
#' the effect of potassium-containing toothpaste on dentine hypersensitivity
#' \insertCite{poulsen2006potassium}{RoBMA} which was used as an example in
#' \insertCite{bartos2021bayesian;textual}{RoBMA}.
#'
#' @format A data.frame with 3 columns and 5 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Poulsen2006"

#' @title 881 estimates from 69 studies of a relationship between employment and
#' educational outcomes collected by \insertCite{kroupova2021student;textual}{RoBMA}
#'
#' @description The data set contains partial correlation coefficients, standard errors,
#' study labels, samples sizes, type of the educational outcome, intensity of the
#' employment, gender of the student population, study location, study design, whether
#' the study controlled for endogenity, and whether the study controlled for motivation.
#' The original data set including additional variables and the publication can be found
#' at http://meta-analysis.cz/students.
#' (Note that some standard errors and employment intensities are missing.)
#'
#' @format A data.frame with 11 columns and 881 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Kroupova2021"

#' @title 18 studies of a relationship between acculturation mismatch and
#' intergenerational cultural conflict collected by
#' \insertCite{lui2015intergenerational;textual}{RoBMA}
#'
#' @description The data set contains correlation coefficients r,
#' sample sizes n, and labels for each study assessing the
#' relationship between acculturation mismatch (that is the result of the contrast
#' between the collectivist cultures of Asian and Latin immigrant groups
#' and the individualist culture in the United States) and intergenerational cultural
#' conflict \insertCite{lui2015intergenerational}{RoBMA} which was used as an
#' example in \insertCite{bartos2020adjusting;textual}{RoBMA}.
#'
#' @format A data.frame with 3 columns and 18 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Lui2015"
