\name{mixmodLearn}
\alias{mixmodLearn}
\title{Create an instance of the [\code{\linkS4class{MixmodLearn}}] class}
\usage{
  mixmodLearn(data, knownPartition, dataType = NULL,
    factor = NULL, models = NULL, criterion = "CV",
    nbCVBlocks = 10, weight = NULL)
}
\arguments{
  \item{data}{matrix or data frame containing quantitative
  or qualitative data. Rows correspond to observations and
  columns correspond to variables.}

  \item{knownPartition}{vector of size number of
  observations. Each cell corresponds to a cluster
  affectation. So the maximum value is the number of
  clusters.}

  \item{dataType}{character. Type of data is either
  "quantitative" or "qualitative". Set as NULL by default,
  type will be guessed depending on variables type.}

  \item{factor}{vector of integer containing the number of
  modalities for each qualitative variable. It is optional
  for qualitative data set and keep it as NULL for
  quantitative data set. Factors can also be generated by
  the nbFactorFromData() method.}

  \item{models}{a [\code{\linkS4class{Model}}] object
  defining the list of models to run. For quantitative
  data, the model "Gaussian_pk_Lk_C" is called (see
  mixmodGaussianModel() to specify other models). For
  qualitative data, the model "Binary_pk_Ekjh" is called
  (see mixmodMultinomialModel() to specify other models).}

  \item{criterion}{list of character defining the criterion
  to select the best model. Possible values: "BIC", "CV" or
  c("CV","BIC"). Default is "CV".}

  \item{nbCVBlocks}{integer which defines the number of
  observation per block to perform the Cross Validation.
  This value will be ignored if the CV criterion is not
  choosen. Default value is 10.}

  \item{weight}{numeric vector with n (number of
  individuals) rows. Weight is optionnal. This option is to
  be used when weight is associated to the data.}
}
\value{
  Returns an instance of the
  [\code{\linkS4class{MixmodLearn}}] class. Those two
  attributes will contain all outputs: \describe{
  \item{results}{a list of
  [\code{\linkS4class{MixmodResults}}] object containing
  all the results sorted in ascending order according to
  the given criterion.} \item{bestResult}{a S4
  [\code{\linkS4class{MixmodResults}}] object containing
  the best model results.} }
}
\description{
  This function computes the first step of a discriminant
  analysis. It will find the best classification rule by
  running an M step from the training observations.
}
\examples{
## A quantitative example with the famous iris data set
  learn.iris<-mixmodLearn(iris[1:4], iris$Species)
  ## get summary
  summary(learn.iris)

  ## An example with the famous birds data set
  data(birds)
  birds.partition<-c(rep(1,34),rep(2,35))
  learn.birds<-mixmodLearn(data=birds, knownPartition=birds.partition, factor=c(2,5,6,3,5,4))
  ## get summary
  summary(learn.birds)
}
\author{
  Remi Lebret and Serge Iovleff and Florent Langrognet,
  with contributions from C. Biernacki and G. Celeux and G.
  Govaert \email{contact@mixmod.org}
}

