% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{ig_auth_check}
\alias{ig_auth_check}
\title{Check that an Authorized Instagram Session Exists}
\usage{
ig_auth_check(verbose = FALSE)
}
\arguments{
\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{Token2.0} object (an S3 class provided by \code{httr}) or a 
a character string of the sessionId element of the current authorized 
API session
}
\description{
Before the user makes any calls requiring an authorized session, check if an 
OAuth token or session is not already available, call \code{\link{ig_auth}} to 
by default initiate the OAuth 2.0 workflow that will load a token from cache or 
launch browser flow. Return the bare token. Use
\code{access_token()} to reveal the actual access token, suitable for use
with \code{curl}.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
