% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{ig_auth}
\alias{ig_auth}
\title{Log in to Instagram}
\usage{
ig_auth(username = NULL, password = NULL, token = NULL,
  client_id = getOption("Rinstapkg.client_id"),
  client_secret = getOption("Rinstapkg.client_secret"),
  callback_url = getOption("Rinstapkg.callback_url"),
  cache = getOption("Rinstapkg.httr_oauth_cache"), verbose = FALSE)
}
\arguments{
\item{username}{Instagram username, use the handle without the "@" sign or an email}

\item{password}{Instagram password}

\item{token}{optional; an actual token object or the path to a valid token
stored as an \code{.rds} file}

\item{client_id, client_secret, callback_url}{the "Client Id","Client Secret", 
and "Callback URL" when using a connected app. The \code{Rinstapkg} does not have 
a default App so you must specify these if using the OAuth2.0 protocol}

\item{cache}{logical or character; TRUE means to cache using the default cache 
file \code{.httr-oauth-Rinstapkg}, FALSE means don't cache. A string means use 
the specified path as the cache file.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Log in using Basic (Username-Password) or OAuth 2.0 authenticaion. OAuth does
not require sharing passwords, but will require authorizing \code{Rinstapkg} 
as a connected app to view and manage your account. You will be directed to 
a web browser, asked to sign in to your Instagram account, and to grant \code{Rinstapkg} 
permission to operate on your behalf. By default, these user credentials are 
cached in a file named \code{.httr-oauth-Rinstapkg} in the current working directory.
}
\examples{
\donttest{
# log in using basic authentication (username-password)
ig_auth(username = "test@gmail.com", 
        password = "test_password")

# log in using OAuth 2.0
# Via brower or refresh of .httr-oauth-Rinstapkg
options(Rinstapkg.client_id = "012345678901-99thisisatest99")
options(Rinstapkg.client_secret = "Th1s1sMyC1ientS3cr3t")
ig_auth()

# Save token and log in using it
saveRDS(.state$token, "token.rds")
ig_auth(token = "token.rds")
}
}
