% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_ilostat.r
\name{distribution_ilostat}
\alias{distribution_ilostat}
\title{Switch ilostat to distribution}
\usage{
distribution_ilostat(x, var, .keep = FALSE)
}
\arguments{
\item{x}{dataset to transform into distribution.}

\item{var}{String variable name use for the distribution default \code{"no"}, 
could be \code{"sex"}, \code{"classif1"}, \code{"classif2"}.}

\item{.keep}{if true return only new column call distribution default \code{FALSE}.}
}
\value{
a data_frame. obs_status will no longer be a number of persons but a percentage.
}
\description{
Get distribution for ilostat number of persons only.
}
\details{
this function use the max of the corresponding grouping so it is 
		important to not filter any subset of the corresponding variable selected for the distribution
	at this level, ie. if you remove SEX_T, the distribution by sex will only have SEX_F or SEX_M / max(SEX_M, SEX_F) * 100,
	which is no longer a distribution.

	In addition, distribution is only applicable for indicators with Number of persons (usually in thousands), 
	So plse do not distribute ratios, earnings, hours of works, CPI, GDP etc ... no warning will prevent for that
	if doubts use distribution from get_ilostat() instead of, warnings will help you.
}
\examples{
\dontrun{
 dat <- get_ilostat("EMP_TEMP_SEX_STE_GEO_NB_A", cache = FALSE)
 dat_dist <- distribution_ilostat(dat, "classif1")
 dat_plus_dist <- mutate(dat, dist = distribution_ilostat(dat,"classif1", .keep=TRUE))
 head(dat_dist)
 clean_ilostat_cache() 
}
}
\references{
See citation("Rilostat")
ilostat bulk download facility user guidelines 
\url{https://webapps.ilo.org/ilostat-files/Documents/ILOSTAT_BulkDownload_Guidelines.pdf}
}
\author{
David Bescond \email{bescond@ilo.org}
}
