% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_stiefel.R
\name{stiefel.runif}
\alias{stiefel.runif}
\title{Generate Uniform Samples on Stiefel Manifold}
\usage{
stiefel.runif(n, k, p, type = c("list", "array", "riemdata"))
}
\arguments{
\item{n}{number of samples to be generated.}

\item{k}{dimension of the frame.}

\item{p}{original dimension (of the ambient space).}

\item{type}{return type; \describe{
\item{\code{"list"}}{a length-\eqn{n} list of \eqn{(p\times k)} basis of \eqn{k}-frames.}
\item{\code{"array"}}{a \eqn{(p\times k\times n)} 3D array whose slices are \eqn{k}-frame basis.}
\item{\code{"riemdata"}}{a S3 object. See \code{\link{wrap.stiefel}} for more details.}
}}
}
\value{
an object from one of the above by \code{type} option.
}
\description{
It generates \eqn{n} random samples from Stiefel manifold \eqn{St(k,p)}.
}
\examples{
#-------------------------------------------------------------------
#                 Draw Samples on Stiefel Manifold 
#
# Try Different Return Types with 3 Observations of 5-frames in R^10
#-------------------------------------------------------------------
#  GENERATION
dat.list = stiefel.runif(n=3, k=5, p=10, type="list")
dat.arr3 = stiefel.runif(n=3, k=5, p=10, type="array")
dat.riem = stiefel.runif(n=3, k=5, p=10, type="riemdata")

}
\references{
\insertRef{chikuse_statistics_2003}{Riemann}
}
\seealso{
\code{\link{wrap.stiefel}}
}
\concept{stiefel}
