% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ricetl.R
\name{id2age}
\alias{id2age}
\title{Extraction Age}
\usage{
id2age(x,year=2018,fillna=NA)
}
\arguments{
\item{x}{A vector containing 18 Bit ID numbers.}

\item{year}{Calculate the reference time of age,the default value is 2018.}

\item{fillna}{The filling value of the missing value,the default value is \emph{NA}}
}
\description{
Extraction of age in the resident identity cards of People's Republic of China.
}
\examples{
library(Ricetl)
x <- c('654003198111200241','341881197709275718',
'340503199401248097','469030199406204103','511100198')
id2age(x)
id2age(x,year=2018,fillna=25)


}
\author{
Xu Jing
}
