% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_variant_annotations}
\alias{search_variant_annotations}
\title{Search for Variant Annotations}
\usage{
search_variant_annotations(client, variant_annotation_set_id,
  reference_id = NULL, reference_name = NULL, start = NULL, end = NULL,
  effects = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{variant_annotation_set_id}{The ID of the Variant Annoation Set to search within.}

\item{reference_id}{Only return variants with reference alleles on th reference with this ID.
One of this field or referenceName is required.}

\item{reference_name}{Only return variants with reference alleles on the reference with this name.
One of this field or referenceId is required.}

\item{start}{The beginning of the window (0-based, inclusive) for which variants
with overlapping reference alleles should be returned.
Genomic positions are non-negative integers less than reference length.
Requests spanning the join of circular genomes are represented as two requests one on each
side of the join (position 0).}

\item{end}{The end of the window (0-based, exclusive) for which variants with overlapping
reference alleles should be returned.}

\item{effects}{A data.frame with columns id, sourceName, sourceVersion, term.
This filter allows variant, transcript combinations to be extracted by
effect type(s). Only return variant annotations
including any of these effects and only return transcript effects
including any of these effects. Exact matching across all fields of the
Sequence Ontology OntologyTerm is required. (A transcript effect may have multiple SO
effects which will all be reported.) If empty, return all variant annotations.}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Variant Annotations
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content
d_id <- datasets$datasets[[1]]$id

## Find a variant set to search in
variant_sets <- ref_client \%>\% search_variant_sets(d_id) \%>\% content()
vs_id <- variant_sets$variantSets[[2]]$id

## Find a variant annotation set to search in
variant_annotation_sets <- ref_client \%>\%
 search_variant_annotation_sets(vs_id) \%>\% content()
vas_id <- variant_annotation_sets$variantAnnotationSets[[1]]$id

## Search for variant annotations in the variant annotation set
variant_annotations <- ref_client \%>\%
 search_variant_annotations(vas_id, reference_name = "1") \%>\% content
variant_annotations$variantAnnotations[[1]]
}

}

