% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_reads}
\alias{search_reads}
\title{Search for Reads}
\usage{
search_reads(client, read_group_ids, reference_id = NULL, start = NULL,
  end = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{read_group_ids}{A list of Read Group IDs. The Read Groups to search. At least one id must be specified.}

\item{reference_id}{The reference to query. Leaving blank returns results
from all references, including unmapped reads - this could be very large.}

\item{start}{The start position (0-based) of this query. If a reference is specified, this defaults to 0.
Genomic positions are non-negative integers less than reference length. Requests spanning
 the join of circular genomes are represented as two requests one on each side of the join (position 0).}

\item{end}{The end position (0-based, exclusive) of this query. If a reference is specified,
this defaults to the reference's length.}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Reads
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Find a read group to search in
read_group_sets <- ref_client \%>\% search_read_group_sets(d_id) \%>\% content()
rg_id <- read_group_sets$readGroupSets[[1]]$readGroups[[1]]$id

## Find a reference_id to map reads (unmapped reads not supported yet)
rs_id <- ref_client \%>\% search_reference_sets \%>\% content() \%>\%
 `$`("referenceSets") \%>\% `[[`(1) \%>\% `$`("id")
ref_id <- ref_client \%>\% search_references(rs_id) \%>\% content() \%>\%
 `$`("references") \%>\% `[[`(1) \%>\% `$`("id")

## Search for reads in the read group set
reads <- ref_client \%>\% search_reads(rg_id, reference_id = ref_id) \%>\% content()
reads

}

}

