% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ga4gh.R
\name{get_ga4gh}
\alias{get_ga4gh}
\alias{get_ga4gh.default}
\alias{get_ga4gh.ga4ghClient}
\alias{get_ga4gh.list}
\title{GET an Object}
\usage{
get_ga4gh(object, ...)

\method{get_ga4gh}{ga4ghClient}(object, operation, id, ...)

\method{get_ga4gh}{default}(object, operation, id, port = NULL, ...)

\method{get_ga4gh}{list}(object, operation, id, ...)
}
\arguments{
\item{object}{An object to GET from. I.e. A ga4ghClient object, a url for the server or a list of either.}

\item{...}{Arguments to pass to other methods}

\item{operation}{The name of the operation. Eg "datasets"}

\item{id}{The ID of the Object}

\item{port}{The port number}
}
\description{
GET an object from the GA4GH API
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{

## Use the client and get an object from the api
ref_client \%>\% get_ga4gh("datasets", "id")

## Or provide the API location as a string
get_ga4gh("http://1kgenomes.ga4gh.org", "datasets", "id")
}

}

