% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_github_data.R
\name{loadJambiData}
\alias{loadJambiData}
\title{Load Jambi MODIS Data from GitHub Repository}
\format{
A list containing two arrays, each with dimensions 33 by 33 by 448. One array represents NDVI
image data, and the other represents EVI image data. The list also contains a date vector of length 448,
specifying the capture date for each 33 by 33 image.
}
\source{
[MODIS Product Information](https://lpdaac.usgs.gov/products/mod13q1v006/)
}
\usage{
loadJambiData()
}
\description{
This function loads the Jambi dataset from a GitHub repository hosted at
https://github.com/haghbinh/dataset/Rfssa_dataset. Hosting datasets on GitHub
rather than including them in the Rfssa R package conserves storage space.
The Jambi dataset contains normalized difference vegetation index (NDVI) and enhanced vegetation
index (EVI) image data from NASA’s MODerate-resolution Imaging Spectroradiometer (MODIS) with
global coverage at a 250 m^2 resolution. The dataset covers the Jambi Province, Indonesia,
known for various forested land uses, including natural forests and plantations.
Monitoring land cover changes is crucial, especially in the context of forest exploitation and
conservation efforts. Seasonal variations significantly impact long-term land cover changes.
Data collection began on February 18, 2000, and continued until July 28, 2019, with data recorded
every 16 days. This dataset is valuable for studying vegetative land cover changes in the region.
}
\examples{
\dontrun{
loadJambiData()
str(Jambi)
}

}
\references{
\enumerate{
  \item Lambin, E., Geist, H., Lepers, E. (1999).
  Dynamics of Land-Use and Land-Cover Change in Tropical Regions.
  \emph{Annual Review of Environment and Resources}, 205-244.
}
}
\seealso{
- The dataset object loaded by this function.
}
