% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftsarithmetic.R
\name{-.fts}
\alias{-.fts}
\title{Subtraction of Functional Time Series}
\usage{
\method{-}{fts}(Y1, Y2)
}
\arguments{
\item{Y1}{An object of class \code{\link{fts}} or numeric.}

\item{Y2}{An object of class \code{\link{fts}} or numeric.}
}
\value{
An object of class \code{\link{fts}}.
}
\description{
A method for functional time series (\code{\link{fts}}) subtraction and fts-scalar subtraction. Note that if the fts is multivariate
then a vector of numerics may be provided allowing for subtraction of different scalars from different variables. For example, multivariate fts-numeric subtraction
follows the form of \code{Y-c(1,2)} if \code{Y} is a bivariate fts.
}
\examples{
\dontrun{
require(Rfssa)
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Callcenter.RData")
D <- matrix(sqrt(Callcenter$calls), nrow = 240)
u <- seq(0, 1, length.out = 240) # Define domain of functional data
d <- 22 # number of basis elements
Y <- Rfssa::fts(list(D), list(list(d, "bspline")), list(u))
plot(Y)
Yminus <- Y[1:4] - Y[5:8] # subtract the functional time series to itself
plot(Yminus)
Yminus2 <- Y - 2 # subtract 2 to every term in the functional time series
plot(Yminus2)
}

}
\seealso{
\code{\link{fts}}
}
