% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftsarithmetic.R
\name{[.fts}
\alias{[.fts}
\title{Indexing into Functional Time Series}
\usage{
\method{[}{fts}(Y, i = "index")
}
\arguments{
\item{Y}{an object of class \code{\link{fts}}}

\item{i}{index}
}
\value{
an object of class \code{\link{fts}}
}
\description{
A method that lets you index into a functional time series (\code{\link{fts}}).
}
\note{
can use ':' as an operator to specify a range of indices
}
\examples{

\dontrun{
require(fda)
require(Rfssa)
data(Callcenter) # Read data
u=seq(0,1,length.out=240) # Define domain of functional data
d=12 # number of basis elements
basis=create.bspline.basis(rangeval = c(0,1),nbasis = d) # create basis object
smooth.calls=smooth.basis(u, matrix(nrow=240,ncol=365,Callcenter$calls), basis)
Y=fts(smooth.calls$fd) # create functional time series
Yind=Y[4:8] # take only the 4th through 8th functions
plot(Yind)
Yminus=Y[4:8]-Y[14:18] # subtract functions from each other
plot(Yminus)
}



}
\seealso{
\code{\link{fts}}
}
