% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{modifyList2}
\alias{modifyList2}
\title{\code{modifyList} for >2 lists}
\usage{
modifyList2(...)
}
\arguments{
\item{...}{One or more named lists.}
}
\description{
This calls \code{\link[utils]{modifyList}} iteratively using 
\code{\link[base]{Reduce}}, so it can handle >2 lists. The 
subsequent list elements that share a name will override 
previous list elements with that same name. It also 
will handle the case where any list is a \code{NULL}
}
\details{
Simply a convenience around 
\code{Reduce(modifyList, list(...))}, with some checks.
}
\examples{
modifyList2(list(a = 1), list(a = 2, b = 2))
modifyList2(list(a = 1), NULL, list(a = 2, b = 2))
modifyList2(list(a = 1), NULL, list(a = 2, b = 2), list(a = 3, c = list(1:10)))
}
