/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.PresentationML;

import java.util.Random;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.HandoutMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesSlidePart;
import org.docx4j.openpackaging.parts.PresentationML.PresentationPropertiesPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.PresentationML.TableStylesPart;
import org.docx4j.openpackaging.parts.PresentationML.TagsPart;
import org.docx4j.openpackaging.parts.PresentationML.ViewPropertiesPart;
import org.pptx4j.jaxb.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbPmlPart<E>
extends JaxbXmlPartXPathAware<E> {
    protected static Logger log = LoggerFactory.getLogger(JaxbPmlPart.class);
    public static final String COMMON_SLIDE_DATA = "<p:cSld  xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:spTree><p:nvGrpSpPr><p:cNvPr id=\"1\" name=\"\"/><p:cNvGrpSpPr/><p:nvPr/></p:nvGrpSpPr><p:grpSpPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"0\" cy=\"0\"/><a:chOff x=\"0\" y=\"0\"/><a:chExt cx=\"0\" cy=\"0\"/></a:xfrm></p:grpSpPr></p:spTree></p:cSld>";
    protected static final String COLOR_MAPPING = "<p:clrMap xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" bg1=\"lt1\" tx1=\"dk1\" bg2=\"lt2\" tx2=\"dk2\" accent1=\"accent1\" accent2=\"accent2\" accent3=\"accent3\" accent4=\"accent4\" accent5=\"accent5\" accent6=\"accent6\" hlink=\"hlink\" folHlink=\"folHlink\"/>";
    protected static Random random = new Random();

    public static long getSlideLayoutOrMasterId() {
        long val = (long)random.nextInt(Integer.MAX_VALUE) + 0x80000000L;
        return val;
    }

    protected long getSlideId() {
        long val = random.nextInt(0x7FFFFF00) + 256;
        return val;
    }

    public JaxbPmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.setJAXBContext(Context.jcPML);
    }

    public JaxbPmlPart() throws InvalidFormatException {
        super(new PartName("/ppt/presentation.xml"));
        this.setJAXBContext(Context.jcPML);
    }

    public static Part newPartForContentType(String contentType, String partName) throws InvalidFormatException, PartUnrecognisedException {
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml") || contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.template.main+xml")) {
            return new MainPresentationPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")) {
            return new SlidePart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")) {
            return new SlideMasterPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml")) {
            return new SlideLayoutPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml")) {
            return new TableStylesPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presProps+xml")) {
            return new PresentationPropertiesPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml")) {
            return new ViewPropertiesPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.tags+xml")) {
            return new TagsPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml")) {
            return new HandoutMasterPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml")) {
            return new NotesMasterPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml")) {
            return new NotesSlidePart(new PartName(partName));
        }
        throw new PartUnrecognisedException("No subclass found for " + partName + " (content type '" + contentType + "')");
    }
}

