/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleTree {
    private static Logger log = LoggerFactory.getLogger(StyleTree.class);
    private Tree<AugmentedStyle> tableTree = new Tree();
    private Tree<AugmentedStyle> pTree = new Tree();
    private Tree<AugmentedStyle> cTree = new Tree();

    public Tree<AugmentedStyle> getTableStylesTree() {
        return this.tableTree;
    }

    public Tree<AugmentedStyle> getParagraphStylesTree() {
        return this.pTree;
    }

    public Tree<AugmentedStyle> getCharacterStylesTree() {
        return this.cTree;
    }

    public StyleTree(Set<String> stylesInUse, Map<String, Style> allStyles) {
        Style style;
        this.tableTree.setRootElement(new Node<Object>(this.tableTree, "table-root", null));
        for (String styleId : stylesInUse) {
            if (this.tableTree.get(styleId) != null) continue;
            Style style2 = allStyles.get(styleId);
            if (style2 == null) {
                log.warn("Couldn't find style: " + styleId);
                continue;
            }
            if (!style2.getType().equals("table")) continue;
            this.addNode(styleId, allStyles, this.tableTree);
        }
        Style rootStyle = allStyles.get("DocDefaults");
        if (rootStyle == null) {
            this.pTree.setRootElement(new Node<Object>(this.pTree, "p-root", null));
        } else {
            AugmentedStyle as = new AugmentedStyle(rootStyle);
            this.pTree.setRootElement(new Node<AugmentedStyle>(this.pTree, "DocDefaults", as));
        }
        for (String styleId : stylesInUse) {
            if (this.pTree.get(styleId) == null) {
                style = allStyles.get(styleId);
                if (style == null) {
                    log.warn("Couldn't find style: " + styleId);
                    continue;
                }
                if (!style.getType().equals("paragraph")) continue;
                log.debug("Adding '" + styleId + "' to paragraph tree");
                this.addNode(styleId, allStyles, this.pTree);
                continue;
            }
            log.debug(styleId + " is already in paragraph tree");
        }
        this.cTree.setRootElement(new Node<Object>(this.cTree, "c-root", null));
        for (String styleId : stylesInUse) {
            if (this.cTree.get(styleId) == null) {
                style = allStyles.get(styleId);
                if (style == null) {
                    log.warn("Couldn't find style: " + styleId);
                    continue;
                }
                if (!style.getType().equals("character")) continue;
                this.addNode(styleId, allStyles, this.cTree);
                continue;
            }
            log.debug(styleId + " is already in character tree");
        }
    }

    private Node<AugmentedStyle> addNode(String styleId, Map<String, Style> allStyles, Tree<AugmentedStyle> tree) {
        log.debug(styleId);
        Style style = allStyles.get(styleId);
        if (style == null) {
            log.error("Couldn't find style: " + styleId);
            return null;
        }
        AugmentedStyle as = new AugmentedStyle(style);
        Node<AugmentedStyle> n = new Node<AugmentedStyle>(tree, styleId, as);
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is not based on anything.");
            tree.getRootElement().addChild(n);
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            log.debug("..based on " + basedOnStyleName);
            if (tree.get(basedOnStyleName) == null) {
                Node<AugmentedStyle> parent = this.addNode(basedOnStyleName, allStyles, tree);
                parent.addChild(n);
            } else {
                tree.get(basedOnStyleName).addChild(n);
            }
        } else {
            log.error("No basedOn set for: " + style.getStyleId());
        }
        return n;
    }

    public static void main(String[] args) throws Exception {
        List<Node<AugmentedStyle>> classVals;
        Node n;
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/StyleResolution.xml";
        WordprocessingMLPackage wmlPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        Set<String> stylesInUse = wmlPackage.getMainDocumentPart().getStylesInUse();
        HashMap<String, Style> allStyles = new HashMap<String, Style>();
        Styles styles = (Styles)wmlPackage.getMainDocumentPart().getStyleDefinitionsPart(false).getJaxbElement();
        for (Style s : styles.getStyle()) {
            allStyles.put(s.getStyleId(), s);
            log.debug("live style: " + s.getStyleId());
        }
        StyleTree st = new StyleTree(stylesInUse, allStyles);
        log.debug("\nParagraph styles\n");
        log.debug(st.pTree.toString());
        log.debug("\nCharacter styles\n");
        log.debug(st.cTree.toString());
        log.debug("\nParagraph classes\n");
        for (Map.Entry<String, Object> pairs : st.pTree.nodes.entrySet()) {
            n = (Node)pairs.getValue();
            classVals = st.pTree.climb(n);
            log.debug(n.name + ":'" + StyleTree.getHtmlClassAttributeValue(st.pTree, n) + "'");
        }
        log.debug("\nRun classes\n");
        for (Map.Entry<String, Object> pairs : st.cTree.nodes.entrySet()) {
            n = (Node)pairs.getValue();
            classVals = st.cTree.climb(n);
            log.debug(n.name + ":'" + StyleTree.getHtmlClassAttributeValue(st.cTree, n) + "'");
        }
    }

    public static String getHtmlClassAttributeValue(Tree<AugmentedStyle> tree, Node<AugmentedStyle> n) {
        if (n == null) {
            log.error("Null node passed");
            return null;
        }
        List<Node<AugmentedStyle>> classVals = tree.climb(n);
        StringBuffer sb = new StringBuffer();
        for (Node<AugmentedStyle> valNode : classVals) {
            if (valNode.getData() == null) continue;
            sb.append(valNode.name + " ");
        }
        return sb.toString();
    }

    public class AugmentedStyle {
        private Style s;

        public AugmentedStyle(Style s) {
            this.s = s;
        }

        public Style getStyle() {
            return this.s;
        }
    }
}

