/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.util.Properties;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Docx4jProperties {
    protected static Logger log = LoggerFactory.getLogger(Docx4jProperties.class);
    private static Properties properties;

    private static void init() {
        properties = new Properties();
        try {
            properties.load(ResourceUtils.getResource("docx4j.properties"));
        }
        catch (Exception e) {
            log.warn("Couldn't find/read docx4j.properties; " + e.getMessage());
        }
    }

    public static String getProperty(String key) {
        if (properties == null) {
            Docx4jProperties.init();
        }
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (properties == null) {
            Docx4jProperties.init();
        }
        return properties.getProperty(key, defaultValue);
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        if (properties == null) {
            Docx4jProperties.init();
        }
        String result = properties.getProperty(key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(result);
    }

    public static Properties getProperties() {
        if (properties == null) {
            Docx4jProperties.init();
        }
        return properties;
    }

    public static void setProperty(String key, Boolean value) {
        if (properties == null) {
            Docx4jProperties.init();
        }
        properties.setProperty(key, value.toString());
    }

    public static void setProperty(String key, String value) {
        if (properties == null) {
            Docx4jProperties.init();
        }
        properties.setProperty(key, value);
    }
}

