/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.model.listnumbering.AbstractListNumberingDefinition;
import org.docx4j.model.listnumbering.ListLevel;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.Numbering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListNumberingDefinition {
    private Numbering.Num numNode;
    protected static Logger log = LoggerFactory.getLogger(ListNumberingDefinition.class);
    private AbstractListNumberingDefinition abstractListDefinition;
    private HashMap<String, ListLevel> levels;
    private String listNumberId;

    public Numbering.Num getNumNode() {
        return this.numNode;
    }

    public ListNumberingDefinition(Numbering.Num numNode, HashMap<String, AbstractListNumberingDefinition> abstractListDefinitions) {
        this.numNode = numNode;
        this.listNumberId = numNode.getNumId().toString();
        log.debug("Constructing model for numId=" + this.listNumberId);
        Numbering.Num.AbstractNumId abstractNumNode = numNode.getAbstractNumId();
        if (abstractNumNode == null) {
            log.warn("No abstractNumId on w:numId=" + this.listNumberId);
        } else {
            this.abstractListDefinition = abstractListDefinitions.get(abstractNumNode.getVal().toString());
            if (this.abstractListDefinition == null) {
                log.warn("No abstractListDefinition for w:numId=" + this.listNumberId);
                return;
            }
            if (this.abstractListDefinition.getLevelCount() != 0 || this.abstractListDefinition.hasLinkedStyle()) {
                // empty if block
            }
            this.levels = new HashMap(this.abstractListDefinition.getLevelCount());
            for (Map.Entry<String, ListLevel> pairs : this.abstractListDefinition.getListLevels().entrySet()) {
                this.levels.put(pairs.getKey(), new ListLevel(pairs.getValue()));
            }
            List<Numbering.Num.LvlOverride> levelOverrideNodes = numNode.getLvlOverride();
            if (levelOverrideNodes != null) {
                for (Numbering.Num.LvlOverride overrideNode : levelOverrideNodes) {
                    Lvl lvl;
                    Numbering.Num.LvlOverride.StartOverride startOverride;
                    log.debug("found LvlOverride " + XmlUtils.marshaltoString(overrideNode, true));
                    if (overrideNode.getIlvl() == null) {
                        log.warn("Missing @w:ilvl! " + XmlUtils.marshaltoString(overrideNode, true));
                        continue;
                    }
                    String overrideLevelId = overrideNode.getIlvl().toString();
                    log.debug(".. " + overrideLevelId);
                    if (!overrideLevelId.equals("") && (startOverride = overrideNode.getStartOverride()) != null && startOverride.getVal() != null) {
                        this.levels.get(overrideLevelId).setStartValue(startOverride.getVal().subtract(BigInteger.ONE));
                        log.debug("level " + overrideLevelId + "starts at " + startOverride.getVal());
                    }
                    if ((lvl = overrideNode.getLvl()) == null || this.levels.get(overrideLevelId) == null) continue;
                    this.levels.get(overrideLevelId).SetOverrides(lvl);
                }
            }
        }
    }

    public AbstractListNumberingDefinition getAbstractListDefinition() {
        return this.abstractListDefinition;
    }

    public ListLevel getLevel(String ilvl) {
        return this.levels.get(ilvl);
    }

    public void IncrementCounter(String level) {
        log.debug("Increment level " + level);
        this.levels.get(level).IncrementCounter();
        int levelNumber = Integer.parseInt(level) + 1;
        String levelString = Integer.toString(levelNumber);
        while (this.levels.containsKey(levelString)) {
            log.debug("Reset level " + levelNumber);
            this.levels.get(levelString).ResetCounter();
            levelString = Integer.toString(++levelNumber);
        }
    }

    public String getListNumberId() {
        return this.listNumberId;
    }

    public String GetCurrentNumberString(String level) {
        ListLevel controllingLvl = this.levels.get(level);
        boolean isLegal = level.equals("1") && controllingLvl.getJaxbAbstractLvl().getIsLgl() != null && controllingLvl.getJaxbAbstractLvl().getIsLgl().isVal();
        String formatString = controllingLvl.getLevelText();
        log.debug("levelText: " + formatString);
        StringBuilder result = new StringBuilder();
        String temp = "";
        for (int i = 0; i < formatString.length(); ++i) {
            temp = formatString.substring(i, i + 1);
            if (temp.equals("%")) {
                if (i >= formatString.length() - 1) continue;
                String formatStringLevel = formatString.substring(i + 1, i + 2);
                int levelId = Integer.parseInt(formatStringLevel) - 1;
                ListLevel lvl = this.levels.get(Integer.toString(levelId));
                if (levelId == 0 && isLegal) {
                    result.append(lvl.getCurrentValueUnformatted());
                } else {
                    result.append(lvl.getCurrentValueFormatted());
                }
                ++i;
                continue;
            }
            result.append(temp);
        }
        return result.toString();
    }

    public String GetFont(String level) {
        return this.levels.get(level).getFont();
    }

    public boolean IsBullet(String level) {
        return this.levels.get(level).IsBullet();
    }

    public boolean LevelExists(String level) {
        return this.levels.containsKey(level);
    }
}

