/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import org.docx4j.customXmlProperties.DatastoreItem;
import org.docx4j.customXmlProperties.SchemaRefs;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.JaxbCustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTSdtContentRun;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SdtRun;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Text;
import org.opendope.answers.Answer;
import org.opendope.answers.Answers;
import org.opendope.conditions.Conditions;
import org.opendope.questions.Question;
import org.opendope.questions.Questionnaire;
import org.opendope.questions.Response;
import org.opendope.xpaths.ObjectFactory;
import org.opendope.xpaths.Xpaths;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMigrator {
    protected XPathsPart xPathsPart;
    protected QuestionsPart questionsPart;
    protected StandardisedAnswersPart standardisedAnswersPart;
    protected String storeItemID;
    protected Map<String, String> keys = new HashMap<String, String>();

    protected void createParts(WordprocessingMLPackage pkgOut) throws Exception {
        ConditionsPart conditionsPart = new ConditionsPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)conditionsPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.addPropertiesPart(conditionsPart, "http://opendope.org/conditions");
        conditionsPart.setJaxbElement(new Conditions());
        this.xPathsPart = new XPathsPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.xPathsPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.addPropertiesPart(this.xPathsPart, "http://opendope.org/xpaths");
        this.xPathsPart.setJaxbElement(new Xpaths());
        this.questionsPart = new QuestionsPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.questionsPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.addPropertiesPart(this.questionsPart, "http://opendope.org/questions");
        this.questionsPart.setJaxbElement(new Questionnaire());
        Questionnaire.Questions questions = new Questionnaire.Questions();
        ((Questionnaire)this.questionsPart.getJaxbElement()).setQuestions(questions);
        this.standardisedAnswersPart = new StandardisedAnswersPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.standardisedAnswersPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.storeItemID = this.addPropertiesPart(this.standardisedAnswersPart, "http://opendope.org/answers");
        this.standardisedAnswersPart.setJaxbElement(new Answers());
    }

    protected String addPropertiesPart(JaxbCustomXmlDataStoragePart<?> customXmlDataStoragePart, String ns) throws InvalidFormatException {
        CustomXmlDataStoragePropertiesPart part = new CustomXmlDataStoragePropertiesPart();
        org.docx4j.customXmlProperties.ObjectFactory of = new org.docx4j.customXmlProperties.ObjectFactory();
        DatastoreItem dsi = of.createDatastoreItem();
        String newItemId = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
        dsi.setItemID(newItemId);
        SchemaRefs srefs = of.createSchemaRefs();
        dsi.setSchemaRefs(srefs);
        SchemaRefs.SchemaRef sref = of.createSchemaRefsSchemaRef();
        sref.setUri(ns);
        srefs.getSchemaRef().add(sref);
        part.setJaxbElement(dsi);
        customXmlDataStoragePart.addTargetPart((Part)part, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        return newItemId;
    }

    protected void createContentControl(RPr rPr, List<Object> replacementContent, String key) {
        if (!this.keys.containsKey(key)) {
            this.addPartEntries(key);
            this.keys.put(key, key);
        }
        SdtRun sdtRun = Context.getWmlObjectFactory().createSdtRun();
        replacementContent.add(sdtRun);
        SdtPr sdtPr = Context.getWmlObjectFactory().createSdtPr();
        sdtRun.setSdtPr(sdtPr);
        SdtPr.Alias alias = Context.getWmlObjectFactory().createSdtPrAlias();
        alias.setVal(key);
        Tag tag = Context.getWmlObjectFactory().createTag();
        tag.setVal("od:xpath=" + key);
        sdtPr.setTag(tag);
        sdtPr.setId();
        CTDataBinding ctDataBinding = Context.getWmlObjectFactory().createCTDataBinding();
        JAXBElement<CTDataBinding> jaxbDB = Context.getWmlObjectFactory().createSdtPrDataBinding(ctDataBinding);
        sdtPr.setDataBinding(ctDataBinding);
        ctDataBinding.setXpath("/oda:answers/oda:answer[@id='" + key + "']");
        ctDataBinding.setPrefixMappings("xmlns:oda='http://opendope.org/answers'");
        ctDataBinding.setStoreItemID(this.storeItemID);
        CTSdtContentRun sdtContent = Context.getWmlObjectFactory().createCTSdtContentRun();
        sdtRun.setSdtContent(sdtContent);
        R rnew = new R();
        rnew.setRPr(rPr);
        Text text = Context.getWmlObjectFactory().createText();
        text.setValue(key);
        rnew.getContent().add(text);
        sdtContent.getContent().add(rnew);
    }

    private void addPartEntries(String key) {
        Answer a = new Answer();
        a.setId(key);
        a.setValue("${" + key + "}");
        ((Answers)this.standardisedAnswersPart.getJaxbElement()).getAnswerOrRepeat().add(a);
        Xpaths.Xpath xp = new ObjectFactory().createXpathsXpath();
        xp.setId(key);
        xp.setQuestionID(key);
        Xpaths.Xpath.DataBinding db = new ObjectFactory().createXpathsXpathDataBinding();
        db.setXpath("/oda:answers/oda:answer[@id='" + key + "']");
        db.setPrefixMappings("xmlns:oda='http://opendope.org/answers'");
        db.setStoreItemID(this.storeItemID);
        xp.setDataBinding(db);
        ((Xpaths)this.xPathsPart.getJaxbElement()).getXpath().add(xp);
        Question q = new Question();
        q.setId(key);
        q.setText(key + "?");
        Response r = new Response();
        r.setFree(new Response.Free());
        ((Questionnaire)this.questionsPart.getJaxbElement()).getQuestions().getQuestion().add(q);
    }
}

