/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractVisitorExporterDelegate;
import org.docx4j.convert.out.common.AbstractVisitorExporterGenerator;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.images.WordXmlPictureE10;
import org.docx4j.model.images.WordXmlPictureE20;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOExporterVisitorGenerator
extends AbstractVisitorExporterGenerator<FOConversionContext> {
    private static String XSL_FO = "http://www.w3.org/1999/XSL/Format";
    public static final AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<FOConversionContext> GENERATOR_FACTORY = new AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<FOConversionContext>(){

        @Override
        public AbstractVisitorExporterGenerator<FOConversionContext> createInstance(FOConversionContext conversionContext, Document document, Node parentNode) {
            return new FOExporterVisitorGenerator(conversionContext, document, parentNode);
        }
    };

    private FOExporterVisitorGenerator(FOConversionContext conversionContext, Document document, Node parentNode) {
        super(conversionContext, document, parentNode);
    }

    @Override
    protected AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<FOConversionContext> getFactory() {
        return GENERATOR_FACTORY;
    }

    @Override
    protected DocumentFragment createImage(int imgType, FOConversionContext conversionContext, Object anchorOrInline) {
        switch (imgType) {
            case 1: {
                return WordXmlPictureE10.createXslFoImgE10((AbstractWmlConversionContext)conversionContext, anchorOrInline);
            }
            case 2: {
                return WordXmlPictureE20.createXslFoImgE20((AbstractWmlConversionContext)conversionContext, anchorOrInline);
            }
        }
        return null;
    }

    @Override
    protected Element createNode(Document doc, int nodeType) {
        switch (nodeType) {
            case 1: {
                return this.document.createElementNS(XSL_FO, "block");
            }
            case 2: {
                return this.document.createElementNS(XSL_FO, "inline");
            }
        }
        return null;
    }

    @Override
    protected Element handlePPr(FOConversionContext conversionContext, PPr pPrDirect, boolean sdt, Element currentParent) {
        Style defaultParagraphStyle;
        Element ret = currentParent;
        PropertyResolver propertyResolver = conversionContext.getPropertyResolver();
        String defaultParagraphStyleId = "Normal";
        if (conversionContext.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false) != null && (defaultParagraphStyle = conversionContext.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle()) != null) {
            defaultParagraphStyleId = defaultParagraphStyle.getStyleId();
        }
        String pStyleVal = null;
        pStyleVal = pPrDirect != null && pPrDirect.getPStyle() != null ? pPrDirect.getPStyle().getVal() : defaultParagraphStyleId;
        this.getLog().debug("style '" + pStyleVal);
        try {
            PPr pPr = null;
            RPr rPr = null;
            pPr = propertyResolver.getEffectivePPr(pPrDirect);
            this.getLog().debug("getting rPr for paragraph style");
            rPr = propertyResolver.getEffectiveRPr(null, pPrDirect);
            if (this.getLog().isDebugEnabled() && pPr != null) {
                this.getLog().debug(XmlUtils.marshaltoString((Object)pPr, true, true));
            }
            boolean inlist = false;
            if (pPr != null && pPr.getNumPr() != null) {
                Emulator.ResultTriple triple;
                inlist = true;
                Element foListBlock = this.document.createElementNS(XSL_FO, "list-block");
                currentParent.appendChild(foListBlock);
                foListBlock.setAttribute("provisional-distance-between-starts", "0.5in");
                if (pPr.getShd() != null) {
                    PShading pShading = new PShading(pPr.getShd());
                    pShading.setXslFO(foListBlock);
                }
                Element foListItem = this.document.createElementNS(XSL_FO, "list-item");
                foListBlock.appendChild(foListItem);
                Element foListItemLabel = this.document.createElementNS(XSL_FO, "list-item-label");
                foListItem.appendChild(foListItemLabel);
                Element foListItemLabelBody = this.document.createElementNS(XSL_FO, "block");
                foListItemLabel.appendChild(foListItemLabelBody);
                if (pPrDirect != null && pPrDirect.getNumPr() != null) {
                    triple = Emulator.getNumber(conversionContext.getWmlPackage(), pStyleVal, pPrDirect.getNumPr().getNumId().getVal().toString(), pPrDirect.getNumPr().getIlvl().getVal().toString());
                } else {
                    PPrBase.NumPr.Ilvl ilvl = pPr.getNumPr().getIlvl();
                    String ilvlString = ilvl == null ? "0" : ilvl.getVal().toString();
                    triple = null;
                    if (pPr.getNumPr().getNumId() != null) {
                        triple = Emulator.getNumber(conversionContext.getWmlPackage(), pStyleVal, pPr.getNumPr().getNumId().getVal().toString(), ilvlString);
                    }
                }
                if (triple == null) {
                    this.getLog().warn("computed number ResultTriple was null");
                    if (this.getLog().isDebugEnabled()) {
                        foListItemLabelBody.setTextContent("nrt");
                    }
                } else {
                    String font;
                    if (triple.getIndent() != null) {
                        Indent indent = new Indent(triple.getIndent());
                        indent.setXslFO(foListBlock);
                    }
                    if (triple.getNumFont() != null && (font = PhysicalFonts.getPhysicalFont(conversionContext.getWmlPackage(), triple.getNumFont())) != null) {
                        foListItemLabelBody.setAttribute("font-family", font);
                    }
                    if (triple.getBullet() != null) {
                        foListItemLabelBody.setTextContent(triple.getBullet());
                    } else if (triple.getNumString() == null) {
                        this.getLog().warn("computed NumString was null!");
                        if (this.getLog().isDebugEnabled()) {
                            foListItemLabelBody.setTextContent("nns");
                        }
                    } else {
                        Text number = this.document.createTextNode(triple.getNumString());
                        foListItemLabelBody.appendChild(number);
                    }
                }
                Element foListItemBody = this.document.createElementNS(XSL_FO, "list-item-body");
                foListItem.appendChild(foListItemBody);
                foListItemBody.setAttribute("start-indent", "body-start()");
                Element foBlockElement = this.document.createElementNS(XSL_FO, "block");
                foListItemBody.appendChild(foBlockElement);
                ret = foBlockElement;
            }
            if (pPr != null) {
                boolean ignoreBorders = !sdt;
                this.createFoAttributes(conversionContext, pPr, currentParent, inlist, ignoreBorders);
            }
            if (rPr != null) {
                FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), rPr, currentParent);
            }
        }
        catch (Exception e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    protected void createFoAttributes(FOConversionContext conversionContext, PPr pPr, Element foBlockElement, boolean inList, boolean ignoreBorders) {
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)conversionContext.getWmlPackage(), pPr);
        for (Property p : properties) {
            if (p == null || ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom)) continue;
            if (inList && !(p instanceof Indent)) {
                p.setXslFO(foBlockElement);
                continue;
            }
            if (inList) continue;
            p.setXslFO(foBlockElement);
        }
    }

    protected static void applyFoAttributes(List<Property> properties, Element foElement) {
        if (properties != null && !properties.isEmpty()) {
            for (int i = 0; i < properties.size(); ++i) {
                properties.get(i).setXslFO(foElement);
            }
        }
    }

    protected static void createFoAttributes(TrPr trPr, Element foBlockElement) {
        if (trPr == null) {
            return;
        }
        FOExporterVisitorGenerator.applyFoAttributes(PropertyFactory.createProperties(trPr), foBlockElement);
    }

    protected static void createFoAttributes(TcPr tcPr, Element foBlockElement) {
        if (tcPr == null) {
            return;
        }
        FOExporterVisitorGenerator.applyFoAttributes(PropertyFactory.createProperties(tcPr), foBlockElement);
    }

    @Override
    protected void handleRPr(FOConversionContext conversionContext, PPr pPrDirect, RPr rPrDirect, Element currentParent) {
        PropertyResolver propertyResolver = conversionContext.getPropertyResolver();
        try {
            RPr rPr = propertyResolver.getEffectiveRPr(rPrDirect, pPrDirect);
            if (this.getLog().isDebugEnabled() && rPr != null) {
                this.getLog().debug(XmlUtils.marshaltoString((Object)rPr, true, true));
            }
            FOExporterVisitorGenerator.createFoAttributes(conversionContext.getWmlPackage(), rPr, currentParent);
        }
        catch (Exception e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    protected static void createFoAttributes(WordprocessingMLPackage wmlPackage, RPr rPr, Element foInlineElement) {
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)wmlPackage, rPr);
        for (Property p : properties) {
            p.setXslFO(foInlineElement);
        }
    }
}

